/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.changelog;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.changelog.AbstractChangeLogEntry;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChangeLogRelease
extends AbstractChangeLogEntry {
    private final Version m_aVersion;

    public ChangeLogRelease(@Nonnull Date date, @Nonnull Version version) {
        super(date);
        this.m_aVersion = ValueEnforcer.notNull(version, "Version");
    }

    @Nonnull
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ChangeLogRelease changeLogRelease = (ChangeLogRelease)object;
        return this.m_aVersion.equals(changeLogRelease.m_aVersion);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aVersion).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("version", this.m_aVersion).toString();
    }
}

