/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.AbstractSoftMap;
import com.helger.commons.collection.impl.MapEntry;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class SoftLinkedHashMap<K, V>
extends AbstractSoftMap<K, V> {
    private final int m_nMaxSize;

    public SoftLinkedHashMap(@Nonnegative int n) {
        super(new InternalLinkedHashMap(n));
        ((InternalLinkedHashMap)this.m_aSrcMap).m_aCallback = new IRemoveEldest<K, V>(){

            @Override
            public boolean removeEldestSoftEntry(Map.Entry<K, V> entry) {
                int n = SoftLinkedHashMap.this.size();
                if (n <= SoftLinkedHashMap.this.m_nMaxSize) {
                    return false;
                }
                SoftLinkedHashMap.this.onRemoveEldestEntry(n, entry);
                return true;
            }
        };
        this.m_nMaxSize = n;
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnegative int n, @Nonnull Map.Entry<K, V> entry) {
    }

    private static class InternalLinkedHashMap<K, V>
    extends LinkedHashMap<K, AbstractSoftMap.SoftValue<K, V>> {
        private static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private IRemoveEldest<K, V> m_aCallback;

        public InternalLinkedHashMap(@Nonnegative int n) {
            super(n, 0.75f, true);
        }

        @Override
        protected final boolean removeEldestEntry(@Nonnull Map.Entry<K, AbstractSoftMap.SoftValue<K, V>> entry) {
            MapEntry mapEntry = new MapEntry(entry.getKey(), entry.getValue().get());
            return this.m_aCallback.removeEldestSoftEntry(mapEntry);
        }
    }

    private static interface IRemoveEldest<K, V> {
        public boolean removeEldestSoftEntry(Map.Entry<K, V> var1);
    }
}

