/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.compare.ISortOrderIndicator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ESortOrder implements ISortOrderIndicator
{
    ASCENDING(1),
    DESCENDING(0);

    public static final ESortOrder DEFAULT;
    private final int m_nValue;

    private ESortOrder(int n2) {
        this.m_nValue = n2;
    }

    @Nonnegative
    public int getValue() {
        return this.m_nValue;
    }

    @Nonnull
    public String getValueAsString() {
        return Integer.toString(this.m_nValue);
    }

    @Override
    public boolean isAscending() {
        return this == ASCENDING;
    }

    @Override
    public boolean isDescending() {
        return this == DESCENDING;
    }

    @Nonnull
    public ESortOrder getAlternate() {
        return this.isAscending() ? DESCENDING : ASCENDING;
    }

    @Nonnull
    public static ESortOrder getFromValueOrDefault(int n) {
        return ESortOrder.getFromValue(n, DEFAULT);
    }

    @Nullable
    public static ESortOrder getFromValue(int n, @Nullable ESortOrder eSortOrder) {
        if (n == ESortOrder.ASCENDING.m_nValue) {
            return ASCENDING;
        }
        if (n == ESortOrder.DESCENDING.m_nValue) {
            return DESCENDING;
        }
        return eSortOrder;
    }

    static {
        DEFAULT = ASCENDING;
    }
}

