/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.exception;

import com.helger.commons.exception.ILoggedException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedRuntimeException
extends RuntimeException
implements ILoggedException {
    public static final boolean DEFAULT_DO_LOG = true;
    public static final String MSG_TEXT = "Runtime exception created.";
    private static final Logger s_aLogger = LoggerFactory.getLogger((String)"ROOT");

    public LoggedRuntimeException() {
        this(true);
    }

    public LoggedRuntimeException(boolean bl) {
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedRuntimeException(@Nullable String string) {
        this(true, string);
    }

    public LoggedRuntimeException(boolean bl, @Nullable String string) {
        super(string);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedRuntimeException(@Nullable Throwable throwable) {
        this(true, throwable);
    }

    public LoggedRuntimeException(boolean bl, @Nullable Throwable throwable) {
        super(throwable);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedRuntimeException(@Nullable String string, @Nullable Throwable throwable) {
        this(true, string, throwable);
    }

    public LoggedRuntimeException(boolean bl, @Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    @Nonnull
    public static RuntimeException newException(@Nullable Throwable throwable) {
        if (throwable instanceof LoggedRuntimeException) {
            return (LoggedRuntimeException)throwable;
        }
        if (throwable instanceof ILoggedException) {
            return new RuntimeException(throwable);
        }
        return new LoggedRuntimeException(throwable);
    }

    @Nonnull
    public static RuntimeException newException(@Nullable String string, @Nullable Throwable throwable) {
        if (throwable instanceof LoggedRuntimeException) {
            return (LoggedRuntimeException)throwable;
        }
        if (throwable instanceof ILoggedException) {
            return new RuntimeException(string, throwable);
        }
        return new LoggedRuntimeException(string, throwable);
    }
}

