/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.id.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CCharset;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.AbstractPersistingLongIDFactory;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FileLongIDFactory
extends AbstractPersistingLongIDFactory {
    @Nonnull
    public static final Charset CHARSET_TO_USE = CCharset.CHARSET_ISO_8859_1_OBJ;
    @Nonnegative
    public static final int DEFAULT_RESERVE_COUNT = 20;
    @Nonnull
    private final File m_aFile;

    public FileLongIDFactory(@Nonnull File file) {
        this(file, 20);
    }

    public FileLongIDFactory(@Nonnull File file, @Nonnegative int n) {
        super(n);
        ValueEnforcer.notNull(file, "File");
        if (!FileHelper.canReadAndWriteFile(file)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + file + "!");
        }
        this.m_aFile = file;
    }

    @Nonnull
    public File getFile() {
        return this.m_aFile;
    }

    @Override
    protected final long readAndUpdateIDCounter(@Nonnegative int n) {
        String string = SimpleFileIO.getFileAsString(this.m_aFile, CHARSET_TO_USE);
        long l = string != null ? StringParser.parseLong(string.trim(), 0L) : 0L;
        SimpleFileIO.writeFile(this.m_aFile, Long.toString(l + (long)n), CHARSET_TO_USE);
        return l;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileLongIDFactory fileLongIDFactory = (FileLongIDFactory)object;
        return this.m_aFile.equals(fileLongIDFactory.m_aFile);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFile).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("file", this.m_aFile).toString();
    }
}

