/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileFilterFilenameNotEquals
extends AbstractFileFilter {
    private final String m_sFilename;

    public FileFilterFilenameNotEquals(@Nonnull @Nonempty String string) {
        this.m_sFilename = ValueEnforcer.notEmpty(string, "Filename");
    }

    @Nonnull
    @Nonempty
    public String getFilename() {
        return this.m_sFilename;
    }

    @Override
    public boolean matchesThisFilter(@Nullable File file) {
        return file != null && !this.m_sFilename.equals(FilenameHelper.getSecureFilename(file.getName()));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileFilterFilenameNotEquals fileFilterFilenameNotEquals = (FileFilterFilenameNotEquals)object;
        return this.m_sFilename.equals(fileFilterFilenameNotEquals.m_sFilename);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sFilename).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("filename", this.m_sFilename).toString();
    }
}

