/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.resolve;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.text.resolve.AbstractEnumTextResolverWithOverrideAndFallback;
import com.helger.commons.text.resourcebundle.ResourceBundleHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EnumTextResolverWithPropertiesOverrideAndFallback
extends AbstractEnumTextResolverWithOverrideAndFallback {
    public static final String PREFIX_OVERRIDE = "properties/override-";
    public static final String PREFIX_FALLBACK = "properties/";
    public static final boolean DEFAULT_USE_RESOURCE_BUNDLE_CACHE = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger(EnumTextResolverWithPropertiesOverrideAndFallback.class);
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsFailed = StatisticsManager.getKeyedCounterHandler(EnumTextResolverWithPropertiesOverrideAndFallback.class.getName() + "$failed");
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final Set<String> m_aUsedOverrideBundles = new HashSet<String>();
    @GuardedBy(value="m_aRWLock")
    private final Set<String> m_aUsedFallbackBundles = new HashSet<String>();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bUseResourceBundleCache = true;
    @GuardedBy(value="m_aRWLock")
    private final Map<String, ResourceBundle> m_aResourceBundleCache = new HashMap<String, ResourceBundle>();

    public void setUseResourceBundleCache(boolean bl) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_bUseResourceBundleCache = bl;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public boolean isUseResourceBundleCache() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_bUseResourceBundleCache;
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceBundle _getResourceBundle(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        this.m_aRWLock.readLock().lock();
        try {
            if (!this.m_bUseResourceBundleCache) {
                ResourceBundle resourceBundle = ResourceBundleHelper.getResourceBundle(string, locale);
                return resourceBundle;
            }
            if (this.m_aResourceBundleCache.containsKey(string)) {
                ResourceBundle resourceBundle = this.m_aResourceBundleCache.get(string);
                return resourceBundle;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aResourceBundleCache.containsKey(string)) {
                ResourceBundle resourceBundle = this.m_aResourceBundleCache.get(string);
                return resourceBundle;
            }
            ResourceBundle resourceBundle = ResourceBundleHelper.getResourceBundle(string, locale);
            this.m_aResourceBundleCache.put(string, resourceBundle);
            ResourceBundle resourceBundle2 = resourceBundle;
            return resourceBundle2;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected String internalGetOverrideString(@Nonnull @PropertyKey String string, @Nonnull Locale locale) {
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            String string2 = PREFIX_OVERRIDE + locale2.toString();
            String string3 = ResourceBundleHelper.getString(this._getResourceBundle(string2, locale2), string);
            if (string3 == null) continue;
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aUsedOverrideBundles.add(string2);
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
            return string3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected String internalGetFallbackString(@Nonnull @PropertyKey String string, @Nonnull Locale locale) {
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            String string2 = PREFIX_FALLBACK + locale2.toString();
            String string3 = ResourceBundleHelper.getString(this._getResourceBundle(string2, locale2), string);
            if (string3 == null) continue;
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aUsedFallbackBundles.add(string2);
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
            return string3;
        }
        s_aStatsFailed.increment(PREFIX_FALLBACK + locale.toString() + ':' + string);
        if (GlobalDebug.isDebugMode()) {
            s_aLogger.warn("getFallbackString (" + string + "; " + locale.toString() + ") failed!");
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllUsedOverrideBundleNames() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<String> set = CollectionHelper.newSet(this.m_aUsedOverrideBundles);
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllUsedFallbackBundleNames() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<String> set = CollectionHelper.newSet(this.m_aUsedFallbackBundles);
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    public void clearCache() {
        this.m_aRWLock.writeLock().lock();
        try {
            ResourceBundleHelper.clearCache();
            this.m_aUsedOverrideBundles.clear();
            this.m_aUsedFallbackBundles.clear();
            this.m_aResourceBundleCache.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Cache was cleared: " + this.getClass().getName());
        }
    }
}

