/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.sort;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.tree.IBasicTree;
import com.helger.commons.tree.sort.ComparatorTreeItemData;
import com.helger.commons.tree.sort.ComparatorTreeItemDataComparable;
import com.helger.commons.tree.sort.ComparatorTreeItemID;
import com.helger.commons.tree.sort.ComparatorTreeItemIDComparable;
import com.helger.commons.tree.util.TreeVisitor;
import com.helger.commons.tree.withid.ITreeItemWithID;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWithIDSorter {
    private static final TreeWithIDSorter s_aInstance = new TreeWithIDSorter();

    private TreeWithIDSorter() {
    }

    private static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, final @Nonnull Comparator<? super ITEMTYPE> comparator) {
        ValueEnforcer.notNull(iBasicTree, "Tree");
        ValueEnforcer.notNull(comparator, "Comparator");
        ((ITreeItemWithID)iBasicTree.getRootItem()).reorderChildrenByItems(comparator);
        TreeVisitor.visitTree(iBasicTree, new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            @Override
            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildrenByItems(comparator);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super KEYTYPE> comparator) {
        ComparatorTreeItemID comparatorTreeItemID = new ComparatorTreeItemID(comparator);
        TreeWithIDSorter._sort(iBasicTree, comparatorTreeItemID);
    }

    public static <KEYTYPE extends Comparable<? super KEYTYPE>, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        ComparatorTreeItemIDComparable comparatorTreeItemIDComparable = new ComparatorTreeItemIDComparable();
        TreeWithIDSorter._sort(iBasicTree, comparatorTreeItemIDComparable);
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super DATATYPE> comparator) {
        ComparatorTreeItemData comparatorTreeItemData = new ComparatorTreeItemData(comparator);
        TreeWithIDSorter._sort(iBasicTree, comparatorTreeItemData);
    }

    public static <KEYTYPE, DATATYPE extends Comparable<? super DATATYPE>, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        ComparatorTreeItemDataComparable comparatorTreeItemDataComparable = new ComparatorTreeItemDataComparable();
        TreeWithIDSorter._sort(iBasicTree, comparatorTreeItemDataComparable);
    }
}

