/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.mail.cte.IContentTransferEncoding;
import com.helger.mail.datasource.InputStreamProviderDataSource;
import com.helger.phase4.attachment.AS4OutgoingAttachment;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.IAS4Attachment;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.util.AS4ResourceHelper;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.wss4j.common.ext.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class WSS4JAttachment
extends Attachment
implements IAS4Attachment {
    public static final String CONTENT_DESCRIPTION_ATTACHMENT = "Attachment";
    public static final String CONTENT_ID_PREFIX = "<attachment=";
    public static final String CONTENT_ID_SUFFIX = ">";
    private static final Logger LOGGER = LoggerFactory.getLogger(WSS4JAttachment.class);
    private final AS4ResourceHelper m_aResHelper;
    private IHasInputStream m_aISP;
    private EContentTransferEncoding m_eCTE = EContentTransferEncoding.BINARY;
    private EAS4CompressionMode m_eCompressionMode;
    private Charset m_aCharset;
    private String m_sUncompressedMimeType;
    private final ICommonsOrderedMap<String, String> m_aCustomPartProps = new CommonsLinkedHashMap();

    public WSS4JAttachment(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable String string) {
        this.m_aResHelper = (AS4ResourceHelper)ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        this.overwriteMimeType(string);
    }

    @Nonnull
    public final AS4ResourceHelper getResHelper() {
        return this.m_aResHelper;
    }

    public void setUniqueID() {
        this.setId(MessageHelperMethods.createRandomContentID());
    }

    @Deprecated(forRemoval=false)
    public final void setMimeType(@Nullable String string) {
        throw new UnsupportedOperationException();
    }

    public final void overwriteMimeType(@Nullable String string) {
        super.setMimeType(string);
        this.m_sUncompressedMimeType = string;
        this.addHeader("Content-Type", string);
    }

    public final void addHeader(String string, String string2) {
        super.addHeader(string, string2);
    }

    @Override
    @Nullable
    public String getUncompressedMimeType() {
        return this.m_sUncompressedMimeType;
    }

    @Override
    @Nonnull
    public InputStream getSourceStream() {
        return this.getSourceStream(this.m_aResHelper);
    }

    @Override
    @Nonnull
    public InputStream getSourceStream(@Nonnull AS4ResourceHelper aS4ResourceHelper) {
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResourceHelper");
        InputStream inputStream = this.m_aISP.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException("Got no InputStream from " + String.valueOf(this.m_aISP));
        }
        aS4ResourceHelper.addCloseable(inputStream);
        return inputStream;
    }

    @Deprecated(forRemoval=false)
    public void setSourceStream(InputStream inputStream) {
        throw new UnsupportedOperationException("Use setSourceStreamProvider instead");
    }

    @Override
    @Nullable
    public IHasInputStream getInputStreamProvider() {
        return this.m_aISP;
    }

    public void setSourceStreamProvider(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        this.m_aISP = iHasInputStream;
    }

    @Override
    @Nonnull
    public final EContentTransferEncoding getContentTransferEncoding() {
        return this.m_eCTE;
    }

    @Nonnull
    public final WSS4JAttachment setContentTransferEncoding(@Nonnull EContentTransferEncoding eContentTransferEncoding) {
        this.m_eCTE = (EContentTransferEncoding)ValueEnforcer.notNull((Object)eContentTransferEncoding, (String)"CTE");
        return this;
    }

    @Override
    @Nullable
    public final EAS4CompressionMode getCompressionMode() {
        return this.m_eCompressionMode;
    }

    @Nonnull
    public final WSS4JAttachment setCompressionMode(@Nonnull EAS4CompressionMode eAS4CompressionMode) {
        ValueEnforcer.notNull((Object)((Object)eAS4CompressionMode), (String)"CompressionMode");
        this.m_eCompressionMode = eAS4CompressionMode;
        super.setMimeType(eAS4CompressionMode.getMimeType().getAsString());
        return this;
    }

    @Override
    @Nullable
    public final Charset getCharsetOrDefault(@Nullable Charset charset) {
        return this.m_aCharset != null ? this.m_aCharset : charset;
    }

    @Override
    public final boolean hasCharset() {
        return this.m_aCharset != null;
    }

    @Nonnull
    public final WSS4JAttachment setCharset(@Nullable Charset charset) {
        this.m_aCharset = charset;
        return this;
    }

    @Nonnull
    private DataSource _getAsDataSource() {
        InputStreamProviderDataSource inputStreamProviderDataSource = new InputStreamProviderDataSource(this.m_aISP, this.getId(), this.getMimeType());
        return inputStreamProviderDataSource.getEncodingAware((IContentTransferEncoding)this.getContentTransferEncoding());
    }

    public void addToMimeMultipart(@Nonnull MimeMultipart mimeMultipart) throws MessagingException {
        ValueEnforcer.notNull((Object)mimeMultipart, (String)"MimeMultipart");
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            String string = (String)entry.getKey();
            if (string.equals("Content-ID") || string.equals("Content-Transfer-Encoding") || string.equals("Content-Type")) continue;
            mimeBodyPart.setHeader(string, (String)entry.getValue());
        }
        Object object = this.getId();
        if (StringHelper.hasText((String)object)) {
            if (((String)object).charAt(0) != '<') {
                object = "<" + (String)object + CONTENT_ID_SUFFIX;
            }
            mimeBodyPart.setHeader("Content-ID", (String)object);
        }
        mimeBodyPart.setDataHandler(new DataHandler(this._getAsDataSource()));
        mimeBodyPart.setHeader("Content-Type", this.getMimeType());
        mimeBodyPart.setHeader("Content-Transfer-Encoding", this.getContentTransferEncoding().getID());
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, String> customPartProperties() {
        return this.m_aCustomPartProps;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.getId()).append("MimeType", (Object)this.getMimeType()).append("Headers", (Object)this.getHeaders()).append("ResourceManager", (Object)this.m_aResHelper).append("ISP", (Object)this.m_aISP).append("CTE", (Enum)this.m_eCTE).append("CM", (Enum)this.m_eCompressionMode).append("Charset", (Object)this.m_aCharset).getToString();
    }

    private static void _addOutgoingHeaders(@Nonnull WSS4JAttachment wSS4JAttachment, @Nullable String string) {
        if (StringHelper.hasNoText((String)wSS4JAttachment.getId())) {
            wSS4JAttachment.setUniqueID();
        }
        wSS4JAttachment.addHeader("Content-Description", CONTENT_DESCRIPTION_ATTACHMENT);
        if (StringHelper.hasText((String)string)) {
            if (string.indexOf(34) >= 0) {
                LOGGER.warn("The filename '" + string + "' contains a double quote which will most likely break the Content-Disposition");
            }
            wSS4JAttachment.addHeader("Content-Disposition", "attachment; filename=\"" + string + "\"");
        }
        wSS4JAttachment.addHeader("Content-ID", CONTENT_ID_PREFIX + wSS4JAttachment.getId() + CONTENT_ID_SUFFIX);
        wSS4JAttachment.addHeader("Content-Type", wSS4JAttachment.getMimeType());
    }

    @Nonnull
    public static WSS4JAttachment createOutgoingFileAttachment(@Nonnull AS4OutgoingAttachment aS4OutgoingAttachment, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) throws IOException {
        if (aS4OutgoingAttachment.hasDataBytes()) {
            WSS4JAttachment wSS4JAttachment = WSS4JAttachment.createOutgoingFileAttachment(aS4OutgoingAttachment.getDataBytes().bytes(), aS4OutgoingAttachment.getContentID(), aS4OutgoingAttachment.getFilename(), aS4OutgoingAttachment.getMimeType(), aS4OutgoingAttachment.getCompressionMode(), aS4OutgoingAttachment.getCharset(), aS4ResourceHelper);
            wSS4JAttachment.customPartProperties().addAll(aS4OutgoingAttachment.customProperties());
            return wSS4JAttachment;
        }
        if (aS4OutgoingAttachment.hasDataFile()) {
            WSS4JAttachment wSS4JAttachment = WSS4JAttachment.createOutgoingFileAttachment(aS4OutgoingAttachment.getDataFile(), aS4OutgoingAttachment.getContentID(), aS4OutgoingAttachment.getFilename(), aS4OutgoingAttachment.getMimeType(), aS4OutgoingAttachment.getCompressionMode(), aS4OutgoingAttachment.getCharset(), aS4ResourceHelper);
            wSS4JAttachment.customPartProperties().addAll(aS4OutgoingAttachment.customProperties());
            return wSS4JAttachment;
        }
        throw new IllegalStateException("Unsupported outgoing attachment data provider: " + String.valueOf(aS4OutgoingAttachment));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static WSS4JAttachment createOutgoingFileAttachment(@Nonnull File file, @Nullable String string, @Nullable String string2, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode, @Nullable Charset charset, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) throws IOException {
        File file2;
        WSS4JAttachment wSS4JAttachment;
        block13: {
            ValueEnforcer.notNull((Object)file, (String)"File");
            ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
            wSS4JAttachment = new WSS4JAttachment(aS4ResourceHelper, iMimeType.getAsString());
            wSS4JAttachment.setId(string);
            wSS4JAttachment.setCharset(charset);
            WSS4JAttachment._addOutgoingHeaders(wSS4JAttachment, string2);
            if (eAS4CompressionMode != null) {
                wSS4JAttachment.setCompressionMode(eAS4CompressionMode);
                file2 = aS4ResourceHelper.createTempFile();
                try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream((File)file2);){
                    if (nonBlockingBufferedOutputStream == null) break block13;
                    try (OutputStream outputStream = eAS4CompressionMode.getCompressStream((OutputStream)nonBlockingBufferedOutputStream);){
                        StreamHelper.copyInputStreamToOutputStream((InputStream)FileHelper.getBufferedInputStream((File)file), (OutputStream)outputStream);
                        break block13;
                    }
                }
            }
            file2 = file;
        }
        wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.multiple(() -> FileHelper.getBufferedInputStream((File)file2)));
        return wSS4JAttachment;
    }

    @Nonnull
    public static WSS4JAttachment createOutgoingFileAttachment(@Nonnull byte[] byArray, @Nullable String string, @Nullable String string2, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode, @Nullable Charset charset, @Nonnull AS4ResourceHelper aS4ResourceHelper) throws IOException {
        ValueEnforcer.notNull((Object)byArray, (String)"Data");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        WSS4JAttachment wSS4JAttachment = new WSS4JAttachment(aS4ResourceHelper, iMimeType.getAsString());
        wSS4JAttachment.setId(string);
        wSS4JAttachment.setCharset(charset);
        WSS4JAttachment._addOutgoingHeaders(wSS4JAttachment, string2);
        if (eAS4CompressionMode != null) {
            File file;
            block14: {
                wSS4JAttachment.setCompressionMode(eAS4CompressionMode);
                file = aS4ResourceHelper.createTempFile();
                try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream((File)file);){
                    if (nonBlockingBufferedOutputStream == null) break block14;
                    try (OutputStream outputStream = eAS4CompressionMode.getCompressStream((OutputStream)nonBlockingBufferedOutputStream);){
                        outputStream.write(byArray);
                    }
                }
            }
            wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.multiple(() -> FileHelper.getBufferedInputStream((File)file)));
        } else {
            wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.multiple(() -> new NonBlockingByteArrayInputStream(byArray)));
        }
        return wSS4JAttachment;
    }

    public static boolean canBeKeptInMemory(long l) {
        return l <= 65536L;
    }

    @Nonnull
    public static WSS4JAttachment createIncomingFileAttachment(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull AS4ResourceHelper aS4ResourceHelper) throws MessagingException, IOException {
        DataSource dataSource;
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"BodyPart");
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        WSS4JAttachment wSS4JAttachment = new WSS4JAttachment(aS4ResourceHelper, mimeBodyPart.getContentType());
        Object object = StringHelper.trimStartAndEnd((String)mimeBodyPart.getContentID(), (char)'<', (char)'>');
        wSS4JAttachment.setId((String)object);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating incoming WSS4J attachment with " + mimeBodyPart.getSize() + " bytes");
        }
        if (WSS4JAttachment.canBeKeptInMemory(mimeBodyPart.getSize())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Keeping WSS4J attachment in-memory");
            }
            if ((dataSource = (object = mimeBodyPart.getDataHandler()).getDataSource()) != null) {
                wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.multiple(() -> {
                    try {
                        return dataSource.getInputStream();
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException("Failed to get InputStream from DataSource", iOException);
                    }
                }));
            } else {
                LOGGER.warn("Having a DataHandler that can be read only once: " + String.valueOf(object));
                wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.once(() -> WSS4JAttachment.lambda$createIncomingFileAttachment$4((DataHandler)object)));
            }
        } else {
            object = aS4ResourceHelper.createTempFile();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Storing WSS4J attachment to temporary file '" + ((File)object).getAbsolutePath() + "'");
            }
            dataSource = FileHelper.getBufferedOutputStream((File)object);
            try {
                mimeBodyPart.getDataHandler().writeTo((OutputStream)dataSource);
            }
            finally {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.multiple(() -> WSS4JAttachment.lambda$createIncomingFileAttachment$5((File)object)));
        }
        object = mimeBodyPart.getAllHeaders();
        while (object.hasMoreElements()) {
            dataSource = (Header)object.nextElement();
            wSS4JAttachment.addHeader(dataSource.getName(), dataSource.getValue());
        }
        wSS4JAttachment.addHeader("Content-Description", CONTENT_DESCRIPTION_ATTACHMENT);
        wSS4JAttachment.addHeader("Content-ID", CONTENT_ID_PREFIX + wSS4JAttachment.getId() + CONTENT_ID_SUFFIX);
        wSS4JAttachment.addHeader("Content-Type", wSS4JAttachment.getMimeType());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished handling of incoming WSS4J attachment");
        }
        return wSS4JAttachment;
    }

    private static /* synthetic */ InputStream lambda$createIncomingFileAttachment$5(File file) {
        return FileHelper.getBufferedInputStream((File)file);
    }

    private static /* synthetic */ InputStream lambda$createIncomingFileAttachment$4(DataHandler dataHandler) {
        try {
            return dataHandler.getInputStream();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to get InputStream from DataHandler", iOException);
        }
    }
}

