/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoKeyEncryptionAlgorithm;
import com.helger.phase4.crypto.ECryptoKeyIdentifierType;
import com.helger.phase4.crypto.ICryptoSessionKeyProvider;
import com.helger.phase4.crypto.IWSSecEncryptCustomizer;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import java.security.Provider;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AS4CryptParams
implements ICloneable<AS4CryptParams> {
    public static final ECryptoKeyIdentifierType DEFAULT_KEY_IDENTIFIER_TYPE = ECryptoKeyIdentifierType.BST_DIRECT_REFERENCE;
    public static final ECryptoKeyEncryptionAlgorithm DEFAULT_KEY_ENCRYPTION_ALGORITHM = ECryptoKeyEncryptionAlgorithm.RSA_OAEP_XENC11;
    public static final String DEFAULT_MGF_ALGORITHM = "http://www.w3.org/2009/xmlenc11#mgf1sha256";
    public static final String DEFAULT_DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final ICryptoSessionKeyProvider DEFAULT_SESSION_KEY_PROVIDER = ICryptoSessionKeyProvider.INSTANCE_RANDOM_AES_128;
    public static final boolean DEFAULT_ENCRYPT_SYMMETRIC_SESSION_KEY = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4CryptParams.class);
    private ECryptoKeyIdentifierType m_eKeyIdentifierType = DEFAULT_KEY_IDENTIFIER_TYPE;
    private ECryptoAlgorithmCrypt m_eAlgorithmCrypt;
    private ECryptoKeyEncryptionAlgorithm m_eKeyEncAlgorithm = DEFAULT_KEY_ENCRYPTION_ALGORITHM;
    private String m_sMGFAlgorithm = "http://www.w3.org/2009/xmlenc11#mgf1sha256";
    private String m_sDigestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
    private X509Certificate m_aCert;
    private String m_sAlias;
    private ICryptoSessionKeyProvider m_aSessionKeyProvider = DEFAULT_SESSION_KEY_PROVIDER;
    private Provider m_aSecurityProviderEncrypt;
    private Provider m_aSecurityProviderDecrypt;
    private boolean m_bEncryptSymmetricSessionKey = true;
    private IWSSecEncryptCustomizer m_aWSSecEncryptCustomizer;

    public boolean isCryptEnabled(@Nullable Consumer<String> consumer) {
        if (this.m_eAlgorithmCrypt == null) {
            return false;
        }
        if (!this.hasCertificate() && !this.hasAlias()) {
            if (consumer != null) {
                consumer.accept("Crypt parameters have an algorithm defined but neither an alias nor a certificate was provided. Therefore encryption is not enabled.");
            }
            return false;
        }
        return true;
    }

    @Nonnull
    public final ECryptoKeyIdentifierType getKeyIdentifierType() {
        return this.m_eKeyIdentifierType;
    }

    @Nonnull
    public final AS4CryptParams setKeyIdentifierType(@Nonnull ECryptoKeyIdentifierType eCryptoKeyIdentifierType) {
        ValueEnforcer.notNull((Object)((Object)eCryptoKeyIdentifierType), (String)"KeyIdentifierType");
        this.m_eKeyIdentifierType = eCryptoKeyIdentifierType;
        return this;
    }

    @Nullable
    public final ECryptoAlgorithmCrypt getAlgorithmCrypt() {
        return this.m_eAlgorithmCrypt;
    }

    @Nonnull
    public final AS4CryptParams setAlgorithmCrypt(@Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt) {
        this.m_eAlgorithmCrypt = eCryptoAlgorithmCrypt;
        return this;
    }

    @Nonnull
    public final ECryptoKeyEncryptionAlgorithm getKeyEncAlgorithm() {
        return this.m_eKeyEncAlgorithm;
    }

    @Nonnull
    public final AS4CryptParams setKeyEncAlgorithm(@Nonnull ECryptoKeyEncryptionAlgorithm eCryptoKeyEncryptionAlgorithm) {
        this.m_eKeyEncAlgorithm = eCryptoKeyEncryptionAlgorithm;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getMGFAlgorithm() {
        return this.m_sMGFAlgorithm;
    }

    @Nonnull
    public final AS4CryptParams setMGFAlgorithm(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MGFAlgorithm");
        this.m_sMGFAlgorithm = string;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getDigestAlgorithm() {
        return this.m_sDigestAlgorithm;
    }

    @Nonnull
    public final AS4CryptParams setDigestAlgorithm(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DigestAlgorithm");
        this.m_sDigestAlgorithm = string;
        return this;
    }

    @Nullable
    public final X509Certificate getCertificate() {
        return this.m_aCert;
    }

    public final boolean hasCertificate() {
        return this.m_aCert != null;
    }

    @Nonnull
    public final AS4CryptParams setCertificate(@Nullable X509Certificate x509Certificate) {
        this.m_aCert = x509Certificate;
        if (x509Certificate != null) {
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                LOGGER.warn("The provided certificate is already expired. Please use a different one: " + certificateExpiredException.getMessage());
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                LOGGER.warn("The provided certificate is not yet valid. Please use a different one: " + certificateNotYetValidException.getMessage());
            }
        }
        return this;
    }

    @Nullable
    public final String getAlias() {
        return this.m_sAlias;
    }

    public final boolean hasAlias() {
        return StringHelper.hasText((String)this.m_sAlias);
    }

    @Nonnull
    public final AS4CryptParams setAlias(@Nullable String string) {
        this.m_sAlias = string;
        return this;
    }

    @Nonnull
    public final ICryptoSessionKeyProvider getSessionKeyProvider() {
        return this.m_aSessionKeyProvider;
    }

    @Nonnull
    public final AS4CryptParams setSessionKeyProvider(@Nonnull ICryptoSessionKeyProvider iCryptoSessionKeyProvider) {
        ValueEnforcer.notNull((Object)iCryptoSessionKeyProvider, (String)"SessionKeyProvider");
        this.m_aSessionKeyProvider = iCryptoSessionKeyProvider;
        return this;
    }

    @Nullable
    public final Provider getSecurityProviderEncrypt() {
        return this.m_aSecurityProviderEncrypt;
    }

    @Nonnull
    public final AS4CryptParams setSecurityProviderEncrypt(@Nullable Provider provider) {
        this.m_aSecurityProviderEncrypt = provider;
        return this;
    }

    @Nullable
    public final Provider getSecurityProviderDecrypt() {
        return this.m_aSecurityProviderDecrypt;
    }

    @Nonnull
    public final AS4CryptParams setSecurityProviderDecrypt(@Nullable Provider provider) {
        this.m_aSecurityProviderDecrypt = provider;
        return this;
    }

    @Nonnull
    public final AS4CryptParams setSecurityProvider(@Nullable Provider provider) {
        return this.setSecurityProviderEncrypt(provider).setSecurityProviderDecrypt(provider);
    }

    public final boolean isEncryptSymmetricSessionKey() {
        return this.m_bEncryptSymmetricSessionKey;
    }

    @Nonnull
    public final AS4CryptParams setEncryptSymmetricSessionKey(boolean bl) {
        this.m_bEncryptSymmetricSessionKey = bl;
        return this;
    }

    @Nullable
    public final IWSSecEncryptCustomizer getWSSecEncryptCustomizer() {
        return this.m_aWSSecEncryptCustomizer;
    }

    public final boolean hasWSSecEncryptCustomizer() {
        return this.m_aWSSecEncryptCustomizer != null;
    }

    @Nonnull
    public final AS4CryptParams setWSSecEncryptCustomizer(@Nullable IWSSecEncryptCustomizer iWSSecEncryptCustomizer) {
        this.m_aWSSecEncryptCustomizer = iWSSecEncryptCustomizer;
        return this;
    }

    @Nonnull
    public final AS4CryptParams setFromPMode(@Nullable PModeLegSecurity pModeLegSecurity) {
        if (pModeLegSecurity == null) {
            this.setAlgorithmCrypt(null);
        } else {
            this.setAlgorithmCrypt(pModeLegSecurity.getX509EncryptionAlgorithm());
        }
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    public void cloneTo(@Nonnull AS4CryptParams aS4CryptParams) {
        ValueEnforcer.notNull((Object)aS4CryptParams, (String)"Target");
        aS4CryptParams.setKeyIdentifierType(this.m_eKeyIdentifierType).setAlgorithmCrypt(this.m_eAlgorithmCrypt).setKeyEncAlgorithm(this.m_eKeyEncAlgorithm).setMGFAlgorithm(this.m_sMGFAlgorithm).setDigestAlgorithm(this.m_sDigestAlgorithm).setCertificate(this.m_aCert).setAlias(this.m_sAlias).setSessionKeyProvider(this.m_aSessionKeyProvider).setSecurityProviderEncrypt(this.m_aSecurityProviderEncrypt).setSecurityProviderDecrypt(this.m_aSecurityProviderDecrypt).setEncryptSymmetricSessionKey(this.m_bEncryptSymmetricSessionKey).setWSSecEncryptCustomizer(this.m_aWSSecEncryptCustomizer);
    }

    @Nonnull
    @ReturnsMutableCopy
    public AS4CryptParams getClone() {
        AS4CryptParams aS4CryptParams = new AS4CryptParams();
        this.cloneTo(aS4CryptParams);
        return aS4CryptParams;
    }

    public String toString() {
        return new ToStringGenerator(null).append("KeyIdentifierType", (Enum)this.m_eKeyIdentifierType).append("AlgorithmCrypt", (Enum)this.m_eAlgorithmCrypt).append("KeyEncAlgorithm", (Enum)this.m_eKeyEncAlgorithm).append("MGFAlgorithm", (Object)this.m_sMGFAlgorithm).append("DigestAlgorithm", (Object)this.m_sDigestAlgorithm).append("Certificate", (Object)this.m_aCert).append("Alias", (Object)this.m_sAlias).append("SessionKeyProvider", (Object)this.m_aSessionKeyProvider).append("SecurityProviderEncrypt", (Object)this.m_aSecurityProviderEncrypt).append("SecurityProviderDecrypt", (Object)this.m_aSecurityProviderDecrypt).append("EncryptSymmetricSessionKey", this.m_bEncryptSymmetricSessionKey).append("WSSecEncryptCustomizer", (Object)this.m_aWSSecEncryptCustomizer).getToString();
    }

    @Nonnull
    @ReturnsMutableObject
    public static AS4CryptParams createDefault() {
        return new AS4CryptParams().setAlgorithmCrypt(ECryptoAlgorithmCrypt.ENCRPYTION_ALGORITHM_DEFAULT);
    }
}

