/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.config.fallback.IConfigWithFallback;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.crypto.CAS4Crypto;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreAndKeyDescriptor;
import java.security.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AS4KeyStoreDescriptor {
    private AS4KeyStoreDescriptor() {
    }

    @Nullable
    public static KeyStoreAndKeyDescriptor createFromConfig() {
        return AS4KeyStoreDescriptor.createFromConfig(AS4Configuration.getConfig(), "org.apache.wss4j.crypto.merlin.", null);
    }

    @Nullable
    public static KeyStoreAndKeyDescriptor createFromConfig(@Nonnull IConfigWithFallback iConfigWithFallback, @Nonnull @Nonempty String string, @Nullable Provider provider) {
        ValueEnforcer.notNull((Object)iConfigWithFallback, (String)"Config");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ConfigPrefix");
        ValueEnforcer.isTrue(() -> StringHelper.endsWith((CharSequence)string, (char)'.'), (String)"ConfigPrefix must end with a dot");
        String string2 = iConfigWithFallback.getAsString((Object)(string + "keystore.type"));
        EKeyStoreType eKeyStoreType = EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string2, (EKeyStoreType)CAS4Crypto.DEFAULT_KEY_STORE_TYPE);
        String string3 = iConfigWithFallback.getAsString((Object)(string + "keystore.file"));
        if (StringHelper.hasNoText((String)string3)) {
            return null;
        }
        char[] cArray = iConfigWithFallback.getAsCharArray((Object)(string + "keystore.password"));
        if (cArray == null) {
            return null;
        }
        String string4 = iConfigWithFallback.getAsString((Object)(string + "keystore.alias"));
        if (StringHelper.hasNoText((String)string4)) {
            return null;
        }
        char[] cArray2 = iConfigWithFallback.getAsCharArray((Object)(string + "keystore.private.password"));
        if (cArray2 == null) {
            return null;
        }
        return new KeyStoreAndKeyDescriptor((IKeyStoreType)eKeyStoreType, string3, cArray, provider, string4, cArray2);
    }
}

