/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.crypto.ECryptoAlgorithmC14N;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.crypto.ECryptoKeyIdentifierType;
import com.helger.phase4.crypto.IWSSecSignatureCustomizer;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import java.security.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AS4SigningParams
implements ICloneable<AS4SigningParams> {
    public static final ECryptoKeyIdentifierType DEFAULT_KEY_IDENTIFIER_TYPE = ECryptoKeyIdentifierType.BST_DIRECT_REFERENCE;
    public static final boolean DEFAULT_USE_SINGLE_CERTIFICATE = true;
    private ECryptoKeyIdentifierType m_eKeyIdentifierType = DEFAULT_KEY_IDENTIFIER_TYPE;
    private ECryptoAlgorithmSign m_eAlgorithmSign;
    private ECryptoAlgorithmSignDigest m_eAlgorithmSignDigest;
    private ECryptoAlgorithmC14N m_eAlgorithmC14N = ECryptoAlgorithmC14N.C14N_ALGORITHM_DEFAULT;
    private Provider m_aSecurityProviderSign;
    private Provider m_aSecurityProviderVerify;
    private boolean m_bUseSingleCertificate = true;
    private IWSSecSignatureCustomizer m_aWSSecSignatureCustomizer;

    public boolean isSigningEnabled() {
        return this.m_eAlgorithmSign != null && this.m_eAlgorithmSignDigest != null;
    }

    @Nonnull
    public final ECryptoKeyIdentifierType getKeyIdentifierType() {
        return this.m_eKeyIdentifierType;
    }

    @Nonnull
    public final AS4SigningParams setKeyIdentifierType(@Nonnull ECryptoKeyIdentifierType eCryptoKeyIdentifierType) {
        ValueEnforcer.notNull((Object)((Object)eCryptoKeyIdentifierType), (String)"KeyIdentifierType");
        this.m_eKeyIdentifierType = eCryptoKeyIdentifierType;
        return this;
    }

    @Nullable
    public final ECryptoAlgorithmSign getAlgorithmSign() {
        return this.m_eAlgorithmSign;
    }

    @Nonnull
    public final AS4SigningParams setAlgorithmSign(@Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        this.m_eAlgorithmSign = eCryptoAlgorithmSign;
        return this;
    }

    @Nullable
    public final ECryptoAlgorithmSignDigest getAlgorithmSignDigest() {
        return this.m_eAlgorithmSignDigest;
    }

    @Nonnull
    public final AS4SigningParams setAlgorithmSignDigest(@Nullable ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest) {
        this.m_eAlgorithmSignDigest = eCryptoAlgorithmSignDigest;
        return this;
    }

    @Nonnull
    public final ECryptoAlgorithmC14N getAlgorithmC14N() {
        return this.m_eAlgorithmC14N;
    }

    @Nonnull
    public final AS4SigningParams setAlgorithmC14N(@Nonnull ECryptoAlgorithmC14N eCryptoAlgorithmC14N) {
        ValueEnforcer.notNull((Object)eCryptoAlgorithmC14N, (String)"AlgorithmC14N");
        this.m_eAlgorithmC14N = eCryptoAlgorithmC14N;
        return this;
    }

    @Nullable
    public final Provider getSecurityProviderSign() {
        return this.m_aSecurityProviderSign;
    }

    @Nonnull
    public final AS4SigningParams setSecurityProviderSign(@Nullable Provider provider) {
        this.m_aSecurityProviderSign = provider;
        return this;
    }

    @Nullable
    public final Provider getSecurityProviderVerify() {
        return this.m_aSecurityProviderVerify;
    }

    @Nonnull
    public final AS4SigningParams setSecurityProviderVerify(@Nullable Provider provider) {
        this.m_aSecurityProviderVerify = provider;
        return this;
    }

    @Nonnull
    public final AS4SigningParams setSecurityProvider(@Nullable Provider provider) {
        return this.setSecurityProviderSign(provider).setSecurityProviderVerify(provider);
    }

    public final boolean isUseSingleCertificate() {
        return this.m_bUseSingleCertificate;
    }

    @Nonnull
    public final AS4SigningParams setUseSingleCertificate(boolean bl) {
        this.m_bUseSingleCertificate = bl;
        return this;
    }

    @Nullable
    public final IWSSecSignatureCustomizer getWSSecSignatureCustomizer() {
        return this.m_aWSSecSignatureCustomizer;
    }

    public final boolean hasWSSecSignatureCustomizer() {
        return this.m_aWSSecSignatureCustomizer != null;
    }

    @Nonnull
    public final AS4SigningParams setWSSecSignatureCustomizer(@Nullable IWSSecSignatureCustomizer iWSSecSignatureCustomizer) {
        this.m_aWSSecSignatureCustomizer = iWSSecSignatureCustomizer;
        return this;
    }

    @Nonnull
    public final AS4SigningParams setFromPMode(@Nullable PModeLegSecurity pModeLegSecurity) {
        if (pModeLegSecurity == null) {
            this.setAlgorithmSign(null);
            this.setAlgorithmSignDigest(null);
        } else {
            this.setAlgorithmSign(pModeLegSecurity.getX509SignatureAlgorithm());
            this.setAlgorithmSignDigest(pModeLegSecurity.getX509SignatureHashFunction());
        }
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    public void cloneTo(@Nonnull AS4SigningParams aS4SigningParams) {
        ValueEnforcer.notNull((Object)aS4SigningParams, (String)"Target");
        aS4SigningParams.setKeyIdentifierType(this.m_eKeyIdentifierType).setAlgorithmSign(this.m_eAlgorithmSign).setAlgorithmSignDigest(this.m_eAlgorithmSignDigest).setAlgorithmC14N(this.m_eAlgorithmC14N).setSecurityProviderSign(this.m_aSecurityProviderSign).setSecurityProviderVerify(this.m_aSecurityProviderVerify).setUseSingleCertificate(this.m_bUseSingleCertificate).setWSSecSignatureCustomizer(this.m_aWSSecSignatureCustomizer);
    }

    @Nonnull
    @ReturnsMutableCopy
    public AS4SigningParams getClone() {
        AS4SigningParams aS4SigningParams = new AS4SigningParams();
        this.cloneTo(aS4SigningParams);
        return aS4SigningParams;
    }

    public String toString() {
        return new ToStringGenerator(null).append("KeyIdentifierType", (Enum)this.m_eKeyIdentifierType).append("AlgorithmSign", (Enum)this.m_eAlgorithmSign).append("AlgorithmSignDigest", (Enum)this.m_eAlgorithmSignDigest).append("AlgorithmC14N", (Enum)this.m_eAlgorithmC14N).append("SecurityProviderSign", (Object)this.m_aSecurityProviderSign).append("SecurityProviderVerify", (Object)this.m_aSecurityProviderVerify).append("UseSingleCertificate", this.m_bUseSingleCertificate).append("WSSecSignatureCustomizer", (Object)this.m_aWSSecSignatureCustomizer).getToString();
    }

    @Nonnull
    @ReturnsMutableObject
    public static AS4SigningParams createDefault() {
        return new AS4SigningParams().setAlgorithmSign(ECryptoAlgorithmSign.SIGN_ALGORITHM_DEFAULT).setAlgorithmSignDigest(ECryptoAlgorithmSignDigest.SIGN_DIGEST_ALGORITHM_DEFAULT).setAlgorithmC14N(ECryptoAlgorithmC14N.C14N_ALGORITHM_DEFAULT);
    }
}

