/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.security.keystore.KeyStoreHelper;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.annotation.Nullable;

public abstract class AbstractAS4CryptoFactory
implements IAS4CryptoFactory {
    protected AbstractAS4CryptoFactory() {
    }

    @Override
    @Nullable
    public KeyStore.PrivateKeyEntry getPrivateKeyEntry() {
        KeyStore keyStore = this.getKeyStore();
        if (keyStore == null) {
            return null;
        }
        String string = this.getKeyAlias();
        char[] cArray = this.getKeyPasswordPerAliasCharArray(string);
        return (KeyStore.PrivateKeyEntry)KeyStoreHelper.loadPrivateKey((KeyStore)keyStore, (String)"phase4 CryptoFactory KeyStore", (String)string, (char[])cArray).getKeyEntry();
    }

    @Nullable
    public X509Certificate getCertificate() {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry();
        return privateKeyEntry == null ? null : (X509Certificate)privateKeyEntry.getCertificate();
    }
}

