/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.phase4.messaging.EAS4MessageMode;
import com.helger.phase4.mgr.MetaAS4Manager;
import java.io.File;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface IAS4OutgoingDumperFileProvider {
    public static final String DEFAULT_FILE_EXTENSION = ".as4out";

    @Nonnull
    public File getFile(@Nonnull EAS4MessageMode var1, @Nonnull @Nonempty String var2, @Nonnegative int var3);

    @Nonnull
    public static String getDefaultDirectoryName(@Nonnull OffsetDateTime offsetDateTime) {
        return offsetDateTime.getYear() + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getMonthValue(), (int)2) + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getDayOfMonth(), (int)2);
    }

    @Nonnull
    public static String getDefaultFilename(@Nonnull OffsetDateTime offsetDateTime, @Nonnull @Nonempty String string, @Nonnegative int n) {
        return PDTIOHelper.getTimeForFilename((LocalTime)offsetDateTime.toLocalTime()) + "-" + FilenameHelper.getAsSecureValidASCIIFilename((String)string) + "-" + n + DEFAULT_FILE_EXTENSION;
    }

    @Nonnull
    public static String getDefaultDirectoryAndFilename(@Nonnull @Nonempty String string, @Nonnegative int n) {
        OffsetDateTime offsetDateTime = MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
        return IAS4OutgoingDumperFileProvider.getDefaultDirectoryName(offsetDateTime) + "/" + IAS4OutgoingDumperFileProvider.getDefaultFilename(offsetDateTime, string, n);
    }
}

