/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.traits.IAddableByTrait;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AS4IncomingHelper {
    private AS4IncomingHelper() {
    }

    @Nonnull
    @Nonempty
    public static IJsonObject getIncomingMetadataAsJson(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        JsonObject jsonObject;
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("IncomingUniqueID", (Object)iAS4IncomingMessageMetadata.getIncomingUniqueID());
        jsonObject2.add("IncomingDT", (Object)PDTWebDateHelper.getAsStringXSD((OffsetDateTime)iAS4IncomingMessageMetadata.getIncomingDT()));
        jsonObject2.add("Mode", (Object)iAS4IncomingMessageMetadata.getMode().getID());
        if (iAS4IncomingMessageMetadata.hasRemoteAddr()) {
            jsonObject2.add("RemoteAddr", (Object)iAS4IncomingMessageMetadata.getRemoteAddr());
        }
        if (iAS4IncomingMessageMetadata.hasRemoteHost()) {
            jsonObject2.add("RemoteHost", (Object)iAS4IncomingMessageMetadata.getRemoteHost());
        }
        if (iAS4IncomingMessageMetadata.hasRemotePort()) {
            jsonObject2.add("RemotePort", iAS4IncomingMessageMetadata.getRemotePort());
        }
        if (iAS4IncomingMessageMetadata.hasRemoteUser()) {
            jsonObject2.add("RemoteUser", (Object)iAS4IncomingMessageMetadata.getRemoteUser());
        }
        JsonArray jsonArray = new JsonArray();
        for (Object object : iAS4IncomingMessageMetadata.cookies()) {
            jsonObject = new JsonObject();
            if (StringHelper.hasText((String)object.getDomain())) {
                jsonObject.add("Domain", (Object)object.getDomain());
            }
            if (StringHelper.hasText((String)object.getPath())) {
                jsonObject.add("Path", (Object)object.getPath());
            }
            jsonObject.add("Secure", object.getSecure());
            jsonObject.add("HttpOnly", object.isHttpOnly());
            jsonObject.add("Name", (Object)object.getName());
            jsonObject.add("Value", (Object)object.getValue());
            jsonObject.add("MaxAge", object.getMaxAge());
            jsonArray.add((IAddableByTrait)jsonObject);
        }
        if (jsonArray.isNotEmpty()) {
            jsonObject2.addJson("Cookies", (IJson)jsonArray);
        }
        jsonArray = new JsonArray();
        for (Object object : iAS4IncomingMessageMetadata.getAllHttpHeaders()) {
            jsonObject = (ICommonsList)object.getValue();
            JsonObject jsonObject3 = new JsonObject();
            if (jsonObject.size() != 1) {
                jsonObject3.add((String)object.getKey(), (Object)new JsonArray().addAll((Iterable)jsonObject));
            } else {
                jsonObject3.add((String)object.getKey(), jsonObject.getFirstOrNull());
            }
            jsonArray.add((IAddableByTrait)jsonObject3);
        }
        if (jsonArray.isNotEmpty()) {
            jsonObject2.addJson("HttpHeaders", (IJson)jsonArray);
        }
        return jsonObject2;
    }
}

