/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.messaging.EAS4MessageMode;
import com.helger.phase4.mgr.MetaAS4Manager;
import jakarta.servlet.http.Cookie;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.util.UUID;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS4IncomingMessageMetadata
implements IAS4IncomingMessageMetadata {
    private final String m_sIncomingUniqueID;
    private final OffsetDateTime m_aIncomingDT;
    private final EAS4MessageMode m_eMode;
    private String m_sRemoteAddr;
    private String m_sRemoteHost;
    private int m_nRemotePort = -1;
    private String m_sRemoteUser;
    private ICommonsList<X509Certificate> m_aRemoteTlsCerts;
    private final ICommonsList<Cookie> m_aCookies = new CommonsArrayList();
    private final HttpHeaderMap m_aHttpHeaderMap = new HttpHeaderMap();
    private String m_sRequestMessageID;

    protected AS4IncomingMessageMetadata(@Nonnull EAS4MessageMode eAS4MessageMode) {
        this(UUID.randomUUID().toString(), MetaAS4Manager.getTimestampMgr().getCurrentDateTime(), eAS4MessageMode);
    }

    protected AS4IncomingMessageMetadata(@Nonnull @Nonempty String string, @Nonnull OffsetDateTime offsetDateTime, @Nonnull EAS4MessageMode eAS4MessageMode) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"sIncomingUniqueID");
        ValueEnforcer.notNull((Object)offsetDateTime, (String)"IncomingDT");
        ValueEnforcer.notNull((Object)((Object)eAS4MessageMode), (String)"Mode");
        this.m_sIncomingUniqueID = string;
        this.m_aIncomingDT = offsetDateTime;
        this.m_eMode = eAS4MessageMode;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getIncomingUniqueID() {
        return this.m_sIncomingUniqueID;
    }

    @Override
    @Nonnull
    public final OffsetDateTime getIncomingDT() {
        return this.m_aIncomingDT;
    }

    @Override
    @Nonnull
    public final EAS4MessageMode getMode() {
        return this.m_eMode;
    }

    @Override
    @Nullable
    public String getRemoteAddr() {
        return this.m_sRemoteAddr;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemoteAddr(@Nullable String string) {
        this.m_sRemoteAddr = string;
        return this;
    }

    @Override
    @Nullable
    public String getRemoteHost() {
        return this.m_sRemoteHost;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemoteHost(@Nullable String string) {
        this.m_sRemoteHost = string;
        return this;
    }

    @Override
    @CheckForSigned
    public int getRemotePort() {
        return this.m_nRemotePort;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemotePort(int n) {
        this.m_nRemotePort = n;
        return this;
    }

    @Override
    @Nullable
    public String getRemoteUser() {
        return this.m_sRemoteUser;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemoteUser(@Nullable String string) {
        this.m_sRemoteUser = string;
        return this;
    }

    @Override
    @Nullable
    @ReturnsMutableObject
    public ICommonsList<X509Certificate> remoteTlsCerts() {
        return this.m_aRemoteTlsCerts;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemoteTlsCerts(@Nullable X509Certificate[] x509CertificateArray) {
        this.m_aRemoteTlsCerts = ArrayHelper.isEmpty((Object[])x509CertificateArray) ? null : new CommonsArrayList((Object[])x509CertificateArray);
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<Cookie> cookies() {
        return this.m_aCookies;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setCookies(@Nullable Cookie[] cookieArray) {
        this.m_aCookies.setAll((Object[])cookieArray);
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public HttpHeaderMap getAllHttpHeaders() {
        return this.m_aHttpHeaderMap.getClone();
    }

    @Nonnull
    public AS4IncomingMessageMetadata setHttpHeaders(@Nullable HttpHeaderMap httpHeaderMap) {
        this.m_aHttpHeaderMap.removeAll();
        if (httpHeaderMap != null) {
            this.m_aHttpHeaderMap.addAllHeaders(httpHeaderMap);
        }
        return this;
    }

    @Override
    @Nullable
    public String getRequestMessageID() {
        return this.m_sRequestMessageID;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRequestMessageID(@Nullable String string) {
        this.m_sRequestMessageID = string;
        return this;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("IncomingUniqueID", (Object)this.m_sIncomingUniqueID).append("IncomingDT", (Object)this.m_aIncomingDT).append("Mode", (Enum)this.m_eMode).append("RemoteAddr", (Object)this.m_sRemoteAddr).append("RemoteHost", (Object)this.m_sRemoteHost).append("RemotePort", this.m_nRemotePort).append("RemoteUser", (Object)this.m_sRemoteUser).append("Cookies", this.m_aCookies).append("RequestMessageID", (Object)this.m_sRequestMessageID).getToString();
    }

    @Nonnull
    public static AS4IncomingMessageMetadata createForRequest() {
        return new AS4IncomingMessageMetadata(EAS4MessageMode.REQUEST);
    }

    @Nonnull
    public static AS4IncomingMessageMetadata createForResponse(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RequestMessageID");
        return new AS4IncomingMessageMetadata(EAS4MessageMode.RESPONSE).setRequestMessageID(string);
    }
}

