/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.mgr;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.phase4.incoming.spi.IAS4IncomingPullRequestProcessorSPI;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AS4IncomingPullRequestProcessorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4IncomingPullRequestProcessorManager.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsList<IAS4IncomingPullRequestProcessorSPI> PROCESSORS = new CommonsArrayList();

    private AS4IncomingPullRequestProcessorManager() {
    }

    public static void reinitProcessors() {
        ICommonsList iCommonsList = ServiceLoaderHelper.getAllSPIImplementations(IAS4IncomingPullRequestProcessorSPI.class);
        if (iCommonsList.isEmpty()) {
            LOGGER.warn("No AS4 message processor is registered. All incoming pull requests will be discarded!");
        } else {
            LOGGER.info("Found " + iCommonsList.size() + " AS4 pull requests processors");
        }
        RW_LOCK.writeLocked(() -> PROCESSORS.setAll((Iterable)iCommonsList));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IAS4IncomingPullRequestProcessorSPI> getAllProcessors() {
        return (ICommonsList)RW_LOCK.readLockedGet(() -> PROCESSORS.getClone());
    }

    static {
        AS4IncomingPullRequestProcessorManager.reinitProcessors();
    }
}

