/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.mgr;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.config.AS4Configuration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AS4ProfileSelector {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static String s_sAS4ProfileID;

    private AS4ProfileSelector() {
    }

    @Nullable
    public static String getCustomDefaultAS4ProfileID() {
        return (String)RW_LOCK.readLockedGet(() -> s_sAS4ProfileID);
    }

    public static void setCustomDefaultAS4ProfileID(@Nullable String string) {
        RW_LOCK.writeLocked(() -> {
            s_sAS4ProfileID = string;
        });
    }

    @Nullable
    public static String getDefaultAS4ProfileID() {
        String string = AS4ProfileSelector.getCustomDefaultAS4ProfileID();
        if (StringHelper.hasNoText((String)string)) {
            string = AS4Configuration.getDefaultAS4ProfileID();
        }
        return string;
    }
}

