/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.soap;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3Messaging;
import com.helger.phase4.ebms3header.Ebms3PartInfo;
import com.helger.phase4.ebms3header.Ebms3PartyId;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3PullRequest;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.AS4IncomingMessageState;
import com.helger.phase4.incoming.IAS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.mgr.AS4IncomingPullRequestProcessorManager;
import com.helger.phase4.incoming.soap.ISoapHeaderElementProcessor;
import com.helger.phase4.incoming.spi.IAS4IncomingPullRequestProcessorSPI;
import com.helger.phase4.marshaller.Ebms3MessagingMarshaller;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.error.EEbmsError;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.model.mpc.IMPC;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IAS4PModeResolver;
import com.helger.xml.XMLHelper;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.ext.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapHeaderElementProcessorExtractEbms3Messaging
implements ISoapHeaderElementProcessor {
    public static final QName QNAME_MESSAGING = new QName("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "Messaging");
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapHeaderElementProcessorExtractEbms3Messaging.class);
    private final IAS4PModeResolver m_aPModeResolver;
    private final Consumer<? super IPMode> m_aPModeConsumer;
    private final IAS4IncomingReceiverConfiguration m_aIncomingReceiverConfiguration;

    public SoapHeaderElementProcessorExtractEbms3Messaging(@Nonnull IAS4PModeResolver iAS4PModeResolver, @Nullable Consumer<? super IPMode> consumer, @Nonnull IAS4IncomingReceiverConfiguration iAS4IncomingReceiverConfiguration) {
        ValueEnforcer.notNull((Object)iAS4PModeResolver, (String)"PModeResolver");
        this.m_aPModeResolver = iAS4PModeResolver;
        this.m_aPModeConsumer = consumer;
        this.m_aIncomingReceiverConfiguration = iAS4IncomingReceiverConfiguration;
    }

    private static boolean _isUseLeg1(@Nonnull Ebms3UserMessage ebms3UserMessage) {
        String string = ebms3UserMessage.getMessageInfo().getMessageId();
        String string2 = ebms3UserMessage.getMessageInfo().getRefToMessageId();
        if (StringHelper.hasText((String)string2) && string.equals(string2)) {
            LOGGER.warn("MessageID and ReferenceToMessageID are the same (" + string + ")!");
        }
        return StringHelper.hasNoText((String)string2) || string2.equals(string);
    }

    @Nullable
    private static String _getMPCIDOfUserMsg(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull PModeLeg pModeLeg) {
        String string = ebms3UserMessage.getMpc();
        if (string == null && pModeLeg.getBusinessInfo() != null) {
            string = pModeLeg.getBusinessInfo().getMPCID();
        }
        return string;
    }

    @Nonnull
    private static ESuccess _checkMPCOfPMode(@Nonnull PModeLeg pModeLeg, @Nonnull IMPCManager iMPCManager, @Nonnull Locale locale, @Nonnull ICommonsList<Ebms3Error> iCommonsList) {
        String string;
        if (pModeLeg.getBusinessInfo() != null && (string = pModeLeg.getBusinessInfo().getMPCID()) != null && !iMPCManager.containsWithID(string)) {
            String string2 = "Error processing the usermessage, PMode-MPC ID '" + string + "' is invalid!";
            LOGGER.error(string2);
            iCommonsList.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).errorDetail(string2).build());
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }

    private static boolean _checkSoapBodyHasPayload(@Nonnull PModeLeg pModeLeg, @Nonnull Document document) {
        Element element = XMLHelper.getFirstChildElementOfName((Node)document.getFirstChild(), (String)pModeLeg.getProtocol().getSoapVersion().getBodyElementName());
        return element != null && element.hasChildNodes();
    }

    private void _notifyPModeResolved(@Nonnull IPMode iPMode) {
        if (this.m_aPModeConsumer != null) {
            this.m_aPModeConsumer.accept(iPMode);
        }
    }

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4IncomingMessageState aS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) {
        IMPCManager iMPCManager = MetaAS4Manager.getMPCMgr();
        IPMode iPMode = null;
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        IMPC iMPC = null;
        String string = null;
        String string2 = null;
        Locale locale = aS4IncomingMessageState.getLocale();
        ErrorList errorList = new ErrorList();
        Ebms3Messaging ebms3Messaging = (Ebms3Messaging)new Ebms3MessagingMarshaller().setCollectErrors(errorList).read((Node)element);
        if (ebms3Messaging == null || errorList.containsAtLeastOneError()) {
            for (IError iError : errorList) {
                String string3 = "Header error: " + iError.getAsString(locale);
                LOGGER.error(string3);
                iCommonsList2.add((Object)EEbmsError.EBMS_INVALID_HEADER.errorBuilder(locale).errorDetail(string3, iError.getLinkedException()).build());
            }
            return ESuccess.FAILURE;
        }
        aS4IncomingMessageState.setMessaging(ebms3Messaging);
        int n = ebms3Messaging.getUserMessageCount();
        if (n > 1) {
            String string4 = "Too many UserMessage objects (" + n + ") contained.";
            LOGGER.error(string4);
            iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string4).build());
            return ESuccess.FAILURE;
        }
        int n2 = ebms3Messaging.getSignalMessageCount();
        if (n2 > 1) {
            String string5 = "Too many SignalMessage objects (" + n2 + ") contained.";
            LOGGER.error(string5);
            iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string5).build());
            return ESuccess.FAILURE;
        }
        if (n + n2 == 0) {
            LOGGER.error("Neither UserMessage nor SignalMessage object contained.");
            iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail("Neither UserMessage nor SignalMessage object contained.").build());
            return ESuccess.FAILURE;
        }
        Ebms3UserMessage ebms3UserMessage = (Ebms3UserMessage)CollectionHelper.getAtIndex(ebms3Messaging.getUserMessage(), (int)0);
        if (ebms3UserMessage != null) {
            Object object;
            Object object2;
            Object object3;
            List<Ebms3PartyId> list;
            Ebms3MessageInfo ebms3MessageInfo = ebms3UserMessage.getMessageInfo();
            if (ebms3MessageInfo != null) {
                aS4IncomingMessageState.setMessageID(ebms3MessageInfo.getMessageId());
                aS4IncomingMessageState.setRefToMessageID(ebms3MessageInfo.getRefToMessageId());
                aS4IncomingMessageState.setMessageTimestamp(ebms3MessageInfo.getTimestamp());
            }
            if ((list = ebms3UserMessage.getPartyInfo().getFrom().getPartyId()).size() > 1) {
                String string6 = "More than one PartyId (" + list.size() + ") is contained in From-Recipient please check the message.";
                LOGGER.error(string6);
                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string6).build());
                return ESuccess.FAILURE;
            }
            List<Ebms3PartyId> list2 = ebms3UserMessage.getPartyInfo().getTo().getPartyId();
            if (list2.size() > 1) {
                String string7 = "More than one PartyId (" + list2.size() + ") is contained in To-Recipient please check the message.";
                LOGGER.error(string7);
                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string7).build());
                return ESuccess.FAILURE;
            }
            string = list.get(0).getValue();
            string2 = list2.get(0).getValue();
            Ebms3CollaborationInfo ebms3CollaborationInfo = ebms3UserMessage.getCollaborationInfo();
            if (ebms3CollaborationInfo != null) {
                object3 = null;
                object2 = ebms3CollaborationInfo.getService().getValue();
                String string8 = ebms3CollaborationInfo.getAction();
                String string9 = null;
                if (ebms3CollaborationInfo.getAgreementRef() != null) {
                    object3 = ebms3CollaborationInfo.getAgreementRef().getPmode();
                    string9 = ebms3CollaborationInfo.getAgreementRef().getValue();
                }
                if ((iPMode = this.m_aPModeResolver.findPMode((String)object3, (String)object2, string8, string, string2, string9, (String)(object = this.m_aIncomingReceiverConfiguration.getReceiverEndpointAddress()))) == null) {
                    String string10 = "Failed to resolve PMode for UserMessage '" + (String)object3 + "' / '" + (String)object2 + "' / '" + string8 + "' / '" + string + "' / '" + string2 + "' / '" + string9 + "' / '" + (String)object + "' using resolver " + String.valueOf(this.m_aPModeResolver);
                    LOGGER.error(string10);
                    iCommonsList2.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).errorDetail(string10).build());
                    return ESuccess.FAILURE;
                }
                this._notifyPModeResolved(iPMode);
            }
            object3 = null;
            object2 = null;
            boolean bl = false;
            if (iPMode != null) {
                int n3;
                object3 = iPMode.getLeg1();
                object2 = iPMode.getLeg2();
                if (iPMode.getMEPBinding().getRequiredLegs() == 2 && object2 == null) {
                    LOGGER.error("Error processing the UserMessage, PMode does not contain leg 2.");
                    iCommonsList2.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).errorDetail("Error processing the UserMessage, PMode does not contain leg 2.").build());
                    return ESuccess.FAILURE;
                }
                boolean bl2 = SoapHeaderElementProcessorExtractEbms3Messaging._isUseLeg1(ebms3UserMessage);
                object = bl2 ? object3 : object2;
                int n4 = n3 = bl2 ? 1 : 2;
                if (object == null) {
                    String string11 = "Error processing the UserMessage, PMode does not contain effective leg " + n3 + ".";
                    LOGGER.error(string11);
                    iCommonsList2.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).errorDetail(string11).build());
                    return ESuccess.FAILURE;
                }
                aS4IncomingMessageState.setEffectivePModeLeg(n3, (PModeLeg)object);
                if (SoapHeaderElementProcessorExtractEbms3Messaging._checkMPCOfPMode((PModeLeg)object, iMPCManager, locale, iCommonsList2).isFailure()) {
                    return ESuccess.FAILURE;
                }
                bl = SoapHeaderElementProcessorExtractEbms3Messaging._checkSoapBodyHasPayload((PModeLeg)object, document);
                String string12 = SoapHeaderElementProcessorExtractEbms3Messaging._getMPCIDOfUserMsg(ebms3UserMessage, (PModeLeg)object);
                iMPC = iMPCManager.getMPCOrDefaultOfID(string12);
                if (iMPC == null) {
                    String string13 = "Error processing the UserMessage, effective MPC ID '" + string12 + "' is unknown!";
                    LOGGER.error(string13);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string13).build());
                    return ESuccess.FAILURE;
                }
            }
            aS4IncomingMessageState.setSoapBodyPayloadPresent(bl);
            Ebms3PayloadInfo ebms3PayloadInfo = ebms3UserMessage.getPayloadInfo();
            if (ebms3PayloadInfo == null || ebms3PayloadInfo.getPartInfo().isEmpty()) {
                if (bl) {
                    LOGGER.error("No PayloadInfo/PartInfo is specified, so no SOAP body payload is allowed.");
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail("No PayloadInfo/PartInfo is specified, so no SOAP body payload is allowed.").build());
                    return ESuccess.FAILURE;
                }
                if (iCommonsList.isNotEmpty()) {
                    LOGGER.error("No PayloadInfo/PartInfo is specified, so no attachments are allowed.");
                    iCommonsList2.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.errorBuilder(locale).errorDetail("No PayloadInfo/PartInfo is specified, so no attachments are allowed.").build());
                    return ESuccess.FAILURE;
                }
            } else {
                if (iCommonsList.size() > ebms3PayloadInfo.getPartInfoCount()) {
                    object = "Error processing the UserMessage, the amount of specified attachments does not correlate with the actual attachments in the UserMessage. Expected " + ebms3PayloadInfo.getPartInfoCount() + " but having " + iCommonsList.size() + " attachments.";
                    LOGGER.error((String)object);
                    iCommonsList2.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.errorBuilder(locale).errorDetail((String)object).build());
                    return ESuccess.FAILURE;
                }
                int n5 = 0;
                for (Ebms3PartInfo ebms3PartInfo : ebms3PayloadInfo.getPartInfo()) {
                    if (StringHelper.hasNoText((String)ebms3PartInfo.getHref())) {
                        if (bl) continue;
                        LOGGER.error("Error processing the UserMessage. Expected a SOAP body payload but there is none present.");
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail("Error processing the UserMessage. Expected a SOAP body payload but there is none present.").build());
                        return ESuccess.FAILURE;
                    }
                    ++n5;
                    String string14 = StringHelper.trimStart((String)ebms3PartInfo.getHref(), (String)MessageHelperMethods.PREFIX_CID);
                    WSS4JAttachment wSS4JAttachment2 = (WSS4JAttachment)iCommonsList.findFirst(wSS4JAttachment -> EqualsHelper.equals((Object)wSS4JAttachment.getId(), (Object)string14));
                    if (wSS4JAttachment2 == null) {
                        LOGGER.warn("Failed to resolve MIME attachment '" + string14 + "' in list of " + String.valueOf(iCommonsList.getAllMapped(Attachment::getId)));
                    }
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (ebms3PartInfo.getPartProperties() != null) {
                        for (Ebms3Property ebms3Property : ebms3PartInfo.getPartProperties().getProperty()) {
                            Object object4;
                            String string15 = ebms3Property.getName();
                            String string16 = ebms3Property.getValue();
                            if (string15.equalsIgnoreCase("MimeType")) {
                                bl3 = StringHelper.hasText((String)string16);
                                continue;
                            }
                            if (string15.equalsIgnoreCase("CompressionType")) {
                                object4 = EAS4CompressionMode.getFromMimeTypeStringOrNull(string16);
                                if (object4 == null) {
                                    String string17 = "Error processing the UserMessage, CompressionType '" + string16 + "' of attachment '" + string14 + "' is not supported.";
                                    LOGGER.error(string17);
                                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string17).build());
                                    return ESuccess.FAILURE;
                                }
                                commonsHashMap.put((Object)string14, object4);
                                bl4 = true;
                                continue;
                            }
                            if (!string15.equalsIgnoreCase("CharacterSet") || !StringHelper.hasText((String)string16)) continue;
                            object4 = CharsetHelper.getCharsetFromNameOrNull((String)string16);
                            if (object4 == null) {
                                String string18 = "Value '" + string16 + "' of property 'CharacterSet' of attachment '" + string14 + "' is not supported";
                                LOGGER.error(string18);
                                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string18).build());
                                return ESuccess.FAILURE;
                            }
                            if (wSS4JAttachment2 == null) continue;
                            wSS4JAttachment2.setCharset((Charset)object4);
                        }
                    }
                    if (!bl4 || bl3) continue;
                    String string19 = "Error processing the UserMessage, MimeType for a compressed attachment ('" + string14 + "') is not present.";
                    LOGGER.error(string19);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string19).build());
                    return ESuccess.FAILURE;
                }
                if (n5 != iCommonsList.size()) {
                    String string20 = "Error processing the UserMessage: the amount of specified attachments does not correlate with the actual attachments in the UserMessage. Expected " + ebms3PayloadInfo.getPartInfoCount() + " but having " + iCommonsList.size() + " attachments. This is an indicator, that an external attached was provided.";
                    LOGGER.error(string20);
                    iCommonsList2.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.errorBuilder(locale).errorDetail(string20).build());
                    return ESuccess.FAILURE;
                }
            }
        } else {
            Ebms3SignalMessage ebms3SignalMessage = ebms3Messaging.getSignalMessageAtIndex(0);
            Ebms3MessageInfo ebms3MessageInfo = ebms3SignalMessage.getMessageInfo();
            if (ebms3MessageInfo != null) {
                aS4IncomingMessageState.setMessageID(ebms3MessageInfo.getMessageId());
                aS4IncomingMessageState.setRefToMessageID(ebms3MessageInfo.getRefToMessageId());
                aS4IncomingMessageState.setMessageTimestamp(ebms3MessageInfo.getTimestamp());
            }
            Ebms3PullRequest ebms3PullRequest = ebms3SignalMessage.getPullRequest();
            Ebms3Receipt ebms3Receipt = ebms3SignalMessage.getReceipt();
            if (ebms3PullRequest != null) {
                String string21 = ebms3PullRequest.getMpc();
                IMPC iMPC2 = iMPCManager.getMPCOfID(string21);
                if (iMPC2 == null) {
                    String string22 = "Failed to resolve the PullRequest MPC '" + string21 + "'";
                    LOGGER.error(string22);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.errorBuilder(locale).errorDetail(string22).build());
                    return ESuccess.FAILURE;
                }
                for (IAS4IncomingPullRequestProcessorSPI iAS4IncomingPullRequestProcessorSPI : AS4IncomingPullRequestProcessorManager.getAllProcessors()) {
                    iPMode = iAS4IncomingPullRequestProcessorSPI.findPMode(ebms3SignalMessage);
                    if (iPMode == null) continue;
                    LOGGER.info("Found PMode '" + (String)iPMode.getID() + "' for MPC '" + string21 + "' in SignalMessage " + String.valueOf(ebms3SignalMessage));
                    this._notifyPModeResolved(iPMode);
                    break;
                }
                if (iPMode == null) {
                    String string23 = "Failed to resolve PMode for PullRequest with MPC '" + string21 + "'";
                    LOGGER.error(string23);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.errorBuilder(locale).errorDetail(string23).build());
                    return ESuccess.FAILURE;
                }
            } else if (ebms3Receipt != null) {
                String string24 = ebms3SignalMessage.getMessageInfo().getRefToMessageId();
                if (StringHelper.hasNoText((String)string24)) {
                    LOGGER.error("The Receipt does not contain a RefToMessageId");
                    iCommonsList2.add((Object)EEbmsError.EBMS_INVALID_RECEIPT.errorBuilder(locale).errorDetail("The Receipt does not contain a RefToMessageId").build());
                    return ESuccess.FAILURE;
                }
            } else if (!ebms3SignalMessage.getError().isEmpty()) {
                for (Ebms3Error ebms3Error : ebms3SignalMessage.getError()) {
                }
            }
        }
        aS4IncomingMessageState.setPMode(iPMode);
        aS4IncomingMessageState.setOriginalSoapDocument(document);
        aS4IncomingMessageState.setOriginalAttachments(iCommonsList);
        aS4IncomingMessageState.setCompressedAttachmentIDs((ICommonsMap<String, EAS4CompressionMode>)commonsHashMap);
        aS4IncomingMessageState.setMPC(iMPC);
        aS4IncomingMessageState.setInitiatorID(string);
        aS4IncomingMessageState.setResponderID(string2);
        return ESuccess.SUCCESS;
    }
}

