/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.mime;

import com.helger.commons.string.ToStringGenerator;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS4MimeMessage
extends MimeMessage {
    private final boolean m_bIsRepeatable;

    @Nonnull
    private static Session _getSafeMailSession(@Nullable Session session) {
        return session != null ? session : Session.getDefaultInstance((Properties)System.getProperties(), null);
    }

    public AS4MimeMessage(@Nullable Session session, boolean bl) {
        super(AS4MimeMessage._getSafeMailSession(session));
        this.m_bIsRepeatable = bl;
    }

    public AS4MimeMessage(@Nullable Session session, @Nonnull InputStream inputStream) throws MessagingException {
        super(AS4MimeMessage._getSafeMailSession(session), inputStream);
        this.m_bIsRepeatable = false;
    }

    public final boolean isRepeatable() {
        return this.m_bIsRepeatable;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("IsRepeatable", this.m_bIsRepeatable).getToString();
    }
}

