/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.mime;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.phase4.model.ESoapVersion;
import com.helger.xml.transform.LoggingTransformErrorListener;
import com.helger.xml.transform.XMLTransformerFactory;
import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.angus.mail.handlers.text_plain;

public class DataContentHandlerSoap12
extends text_plain {
    private static final ActivationDataFlavor[] FLAVORS = new ActivationDataFlavor[]{new ActivationDataFlavor(StreamSource.class, ESoapVersion.SOAP_12.getMimeType().getAsStringWithoutParameters(), "SOAP")};

    @Nonnull
    @ReturnsMutableObject(value="design")
    protected ActivationDataFlavor[] getDataFlavors() {
        return FLAVORS;
    }

    @Nonnull
    protected Object getData(@Nonnull ActivationDataFlavor activationDataFlavor, @Nonnull DataSource dataSource) throws IOException {
        if (activationDataFlavor.getRepresentationClass() == StreamSource.class) {
            return new StreamSource(dataSource.getInputStream());
        }
        throw new IOException("Unsupported flavor " + String.valueOf(activationDataFlavor) + " on DS " + String.valueOf(dataSource));
    }

    public void writeTo(@Nonnull Object object, @Nonnull String string, @Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        block4: {
            try {
                TransformerFactory transformerFactory = XMLTransformerFactory.createTransformerFactory((ErrorListener)new LoggingTransformErrorListener(Locale.ROOT), null);
                XMLTransformerFactory.makeTransformerFactorySecure((TransformerFactory)transformerFactory, (String[])ArrayHelper.EMPTY_STRING_ARRAY);
                Transformer transformer = XMLTransformerFactory.newTransformer((TransformerFactory)transformerFactory);
                StreamResult streamResult = new StreamResult(outputStream);
                if (object instanceof DataSource) {
                    transformer.transform(new StreamSource(((DataSource)object).getInputStream()), streamResult);
                    break block4;
                }
                if (object instanceof Source) {
                    transformer.transform((Source)object, streamResult);
                    break block4;
                }
                throw new IOException("Invalid Object type = " + String.valueOf(object.getClass()) + ". DataContentHandlerSoap12 can only convert DataSource or Source to XML.");
            }
            catch (RuntimeException | TransformerException exception) {
                throw new IOException("Unable to run the JAXP transformer on a stream", exception);
            }
        }
    }
}

