/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EMEPBinding implements IHasID<String>
{
    PUSH("push", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/push", 1),
    PULL("pull", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/pull", 1),
    SYNC("sync", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/sync", 2),
    PUSH_PUSH("pushpush", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/pushAndPush", 2),
    PUSH_PULL("pushpull", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/pushAndPull", 2),
    PULL_PUSH("pullpush", "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/pullAndPush", 2);

    public static final EMEPBinding DEFAULT_EBMS;
    private final String m_sID;
    private final String m_sURI;
    private final int m_nRequiredLegs;

    private EMEPBinding(String string2, String string3, int n2) {
        this.m_sID = string2;
        this.m_sURI = string3;
        this.m_nRequiredLegs = n2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getURI() {
        return this.m_sURI;
    }

    @Nonnegative
    public int getRequiredLegs() {
        return this.m_nRequiredLegs;
    }

    public boolean isSynchronous() {
        return this == PUSH || this == PULL || this == SYNC;
    }

    public boolean isAsynchronous() {
        return this == PUSH_PUSH || this == PUSH_PULL || this == PULL_PUSH;
    }

    public boolean isAsynchronousInitiator() {
        return this == PUSH_PULL || this == PULL_PUSH;
    }

    public boolean canSendUserMessageBack() {
        return this == PULL || this == SYNC || this == PULL_PUSH || this == PUSH_PULL;
    }

    @Nullable
    public static EMEPBinding getFromIDOrNull(@Nullable String string) {
        return (EMEPBinding)EnumHelper.getFromIDOrNull(EMEPBinding.class, (Object)string);
    }

    @Nullable
    public static EMEPBinding getFromURIOrNull(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (EMEPBinding)EnumHelper.findFirst(EMEPBinding.class, eMEPBinding -> string.equals(eMEPBinding.getURI()));
    }

    static {
        DEFAULT_EBMS = PUSH;
    }
}

