/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.string.StringHelper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ESoapVersion {
    SOAP_11("http://schemas.xmlsoap.org/soap/envelope/", "S11", CMimeType.TEXT_XML, "1.1"),
    SOAP_12("http://www.w3.org/2003/05/soap-envelope", "S12", CMimeType.APPLICATION_SOAP_XML, "1.2");

    public static final ESoapVersion AS4_DEFAULT;
    private final String m_sNamespaceURI;
    private final String m_sNamespacePrefix;
    private final IMimeType m_aMimeType;
    private final String m_sVersion;

    private ESoapVersion(@Nonnull String string2, @Nonnull @Nonempty String string3, IMimeType iMimeType, String string4) {
        this.m_sNamespaceURI = string2;
        this.m_sNamespacePrefix = string3;
        this.m_aMimeType = iMimeType;
        this.m_sVersion = string4;
    }

    @Nonnull
    @Nonempty
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Nonnull
    @Nonempty
    public String getNamespacePrefix() {
        return this.m_sNamespacePrefix;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MimeType getMimeType(@Nonnull Charset charset) {
        return new MimeType(this.m_aMimeType).addParameter("charset", charset.name());
    }

    @Nonnull
    @Nonempty
    public String getVersion() {
        return this.m_sVersion;
    }

    @Nonnull
    @Nonempty
    public String getMustUnderstandValue(boolean bl) {
        if (this == SOAP_11) {
            return bl ? "1" : "0";
        }
        return Boolean.toString(bl);
    }

    @Nonnull
    public String getHeaderElementName() {
        return "Header";
    }

    @Nonnull
    public String getBodyElementName() {
        return "Body";
    }

    public boolean isAS4Default() {
        return this == AS4_DEFAULT;
    }

    @Nullable
    public static ESoapVersion getFromVersionOrNull(@Nullable String string) {
        return ESoapVersion.getFromVersionOrDefault(string, null);
    }

    @Nullable
    public static ESoapVersion getFromVersionOrDefault(@Nullable String string, @Nullable ESoapVersion eSoapVersion2) {
        if (StringHelper.hasNoText((String)string)) {
            return eSoapVersion2;
        }
        return (ESoapVersion)((Object)ArrayHelper.findFirst((Object[])ESoapVersion.values(), eSoapVersion -> eSoapVersion.getVersion().equals(string), (Object)((Object)eSoapVersion2)));
    }

    @Nullable
    public static ESoapVersion getFromNamespaceURIOrNull(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (ESoapVersion)((Object)ArrayHelper.findFirst((Object[])ESoapVersion.values(), eSoapVersion -> eSoapVersion.getNamespaceURI().equals(string)));
    }

    @Nullable
    public static ESoapVersion getFromMimeTypeOrNull(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return null;
        }
        return (ESoapVersion)((Object)ArrayHelper.findFirst((Object[])ESoapVersion.values(), eSoapVersion -> eSoapVersion.getMimeType().equals((Object)iMimeType)));
    }

    static {
        AS4_DEFAULT = SOAP_12;
    }
}

