/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.ebms3header.Ebms3Property;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public class MessageProperty {
    private final String m_sName;
    private final String m_sType;
    private final String m_sValue;

    public MessageProperty(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull @Nonempty String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"Value");
        this.m_sName = string;
        this.m_sType = string2;
        this.m_sValue = string3;
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Nullable
    public final String getType() {
        return this.m_sType;
    }

    @Nonnull
    @Nonempty
    public final String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Ebms3Property getAsEbms3Property() {
        Ebms3Property ebms3Property = new Ebms3Property();
        ebms3Property.setName(this.m_sName);
        ebms3Property.setType(this.m_sType);
        ebms3Property.setValue(this.m_sValue);
        return ebms3Property;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MessageProperty messageProperty = (MessageProperty)object;
        return EqualsHelper.equals((Object)this.m_sName, (Object)messageProperty.m_sName) && EqualsHelper.equals((Object)this.m_sType, (Object)messageProperty.m_sType) && EqualsHelper.equals((Object)this.m_sValue, (Object)messageProperty.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sName).append((Object)this.m_sType).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("m_sName", (Object)this.m_sName).append("m_sType", (Object)this.m_sType).append("m_sValue", (Object)this.m_sValue).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable Ebms3Property ebms3Property) {
        Builder builder = new Builder();
        if (ebms3Property != null) {
            builder.name(ebms3Property.getName()).type(ebms3Property.getType()).value(ebms3Property.getValue());
        }
        return builder;
    }

    public static class Builder
    implements IBuilder<MessageProperty> {
        private String m_sName;
        private String m_sType;
        private String m_sValue;

        protected Builder() {
        }

        @Nonnull
        public Builder name(@Nullable String string) {
            this.m_sName = string;
            return this;
        }

        @Nonnull
        public Builder type(@Nullable String string) {
            this.m_sType = string;
            return this;
        }

        @Nonnull
        public Builder value(@Nullable String string) {
            this.m_sValue = string;
            return this;
        }

        @OverridingMethodsMustInvokeSuper
        public void checkConsistency() {
            if (StringHelper.hasNoText((String)this.m_sName)) {
                throw new IllegalStateException("Name MUST be present");
            }
            if (StringHelper.hasNoText((String)this.m_sValue)) {
                throw new IllegalStateException("Value MUST be present");
            }
        }

        @Nonnull
        public MessageProperty build() {
            this.checkConsistency();
            return new MessageProperty(this.m_sName, this.m_sType, this.m_sValue);
        }
    }
}

