/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.message;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.phase4.ebms3header.Ebms3Messaging;
import com.helger.phase4.marshaller.Ebms3MessagingMarshaller;
import com.helger.phase4.marshaller.Soap11EnvelopeMarshaller;
import com.helger.phase4.marshaller.Soap12EnvelopeMarshaller;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.message.EAS4MessageType;
import com.helger.phase4.model.message.IAS4Message;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.soap11.Soap11Body;
import com.helger.phase4.soap11.Soap11Envelope;
import com.helger.phase4.soap11.Soap11Header;
import com.helger.phase4.soap12.Soap12Body;
import com.helger.phase4.soap12.Soap12Envelope;
import com.helger.phase4.soap12.Soap12Header;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractAS4Message<IMPLTYPE extends AbstractAS4Message<IMPLTYPE>>
implements IAS4Message,
IGenericImplTrait<IMPLTYPE> {
    private static final QName QNAME_WSU_ID = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    private final ESoapVersion m_eSoapVersion;
    private final EAS4MessageType m_eMsgType;
    private final String m_sMessagingID;
    protected final Ebms3Messaging m_aMessaging = new Ebms3Messaging();

    public AbstractAS4Message(@Nonnull ESoapVersion eSoapVersion, @Nonnull EAS4MessageType eAS4MessageType) {
        this.m_eSoapVersion = (ESoapVersion)((Object)ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion"));
        this.m_eMsgType = (EAS4MessageType)((Object)ValueEnforcer.notNull((Object)((Object)eAS4MessageType), (String)"MessageType"));
        this.m_sMessagingID = MessageHelperMethods.createRandomMessagingID();
        this.m_aMessaging.getOtherAttributes().put(QNAME_WSU_ID, this.m_sMessagingID);
    }

    @Override
    @Nonnull
    public final ESoapVersion getSoapVersion() {
        return this.m_eSoapVersion;
    }

    @Override
    @Nonnull
    public final EAS4MessageType getMessageType() {
        return this.m_eMsgType;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getMessagingID() {
        return this.m_sMessagingID;
    }

    @Nonnull
    public final IMPLTYPE setMustUnderstand(boolean bl) {
        switch (this.m_eSoapVersion) {
            case SOAP_11: {
                this.m_aMessaging.setS11MustUnderstand(bl);
                break;
            }
            case SOAP_12: {
                this.m_aMessaging.setS12MustUnderstand(bl);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported SOAP version " + String.valueOf((Object)this.m_eSoapVersion));
            }
        }
        return (IMPLTYPE)((AbstractAS4Message)this.thisAsT());
    }

    @Override
    @Nonnull
    public final Document getAsSoapDocument(@Nullable Node node) {
        Element element = new Ebms3MessagingMarshaller().getAsElement(this.m_aMessaging);
        if (element == null) {
            throw new IllegalStateException("Failed to write EBMS3 Messaging to XML");
        }
        Node node2 = node instanceof Document ? ((Document)node).getDocumentElement() : node;
        switch (this.m_eSoapVersion) {
            case SOAP_11: {
                Document document;
                Soap11Envelope soap11Envelope = new Soap11Envelope();
                soap11Envelope.setHeader(new Soap11Header());
                soap11Envelope.getHeader().addAny(element);
                soap11Envelope.setBody(new Soap11Body());
                if (node2 != null) {
                    soap11Envelope.getBody().addAny(node2);
                }
                if ((document = new Soap11EnvelopeMarshaller().getAsDocument(soap11Envelope)) == null) {
                    throw new IllegalStateException("Failed to serialize SOAP 1.1 document");
                }
                return document;
            }
            case SOAP_12: {
                Document document;
                Soap12Envelope soap12Envelope = new Soap12Envelope();
                soap12Envelope.setHeader(new Soap12Header());
                soap12Envelope.getHeader().addAny(element);
                soap12Envelope.setBody(new Soap12Body());
                if (node2 != null) {
                    soap12Envelope.getBody().addAny(node2);
                }
                if ((document = new Soap12EnvelopeMarshaller().getAsDocument(soap12Envelope)) == null) {
                    throw new IllegalStateException("Failed to serialize SOAP 1.2 document");
                }
                return document;
            }
        }
        throw new IllegalStateException("Unsupported SOAP version " + String.valueOf((Object)this.m_eSoapVersion));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SOAPVersion", (Enum)this.m_eSoapVersion).append("MsgType", (Enum)this.m_eMsgType).append("MessagingID", (Object)this.m_sMessagingID).append("Messaging", (Object)this.m_aMessaging).getToString();
    }
}

