/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.mpc;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.EChange;
import com.helger.commons.type.ObjectType;
import com.helger.dao.DAOException;
import com.helger.phase4.model.mpc.IMPC;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.mpc.MPC;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.io.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.tenancy.AbstractBusinessObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MPCManagerXML
extends AbstractPhotonMapBasedWALDAO<IMPC, MPC>
implements IMPCManager {
    public MPCManagerXML(@Nullable String string) throws DAOException {
        super(MPC.class, string);
    }

    @Nonnull
    protected EChange onInit() {
        this.createMPC(new MPC("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultMPC"));
        return EChange.CHANGED;
    }

    @Override
    public void createMPC(@Nonnull MPC mPC) {
        ValueEnforcer.notNull((Object)mPC, (String)"MPC");
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem((IHasID)mPC));
        AuditHelper.onAuditCreateSuccess((ObjectType)MPC.OT, (Object[])new Object[]{mPC.getID()});
    }

    @Override
    @Nonnull
    public EChange updateMPC(@Nonnull IMPC iMPC) {
        ValueEnforcer.notNull((Object)iMPC, (String)"MPC");
        MPC mPC = (MPC)this.getOfID((String)iMPC.getID());
        if (mPC == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)MPC.OT, (String)((String)iMPC.getID()), (Object[])new Object[]{"no-such-id"});
            return EChange.UNCHANGED;
        }
        if (mPC.isDeleted()) {
            AuditHelper.onAuditModifyFailure((ObjectType)MPC.OT, (String)((String)iMPC.getID()), (Object[])new Object[]{"already-deleted"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            BusinessObjectHelper.setLastModificationNow((AbstractBusinessObject)mPC);
            this.internalUpdateItem((IHasID)mPC);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)MPC.OT, (String)"all", (Object[])new Object[]{mPC.getID()});
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange markMPCDeleted(@Nullable String string) {
        MPC mPC = (MPC)this.getOfID(string);
        if (mPC == null) {
            AuditHelper.onAuditDeleteFailure((ObjectType)MPC.OT, (Object[])new Object[]{"no-such-object-id", string});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow((AbstractBusinessObject)mPC).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure((ObjectType)MPC.OT, (Object[])new Object[]{"already-deleted", string});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted((IHasID)mPC);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)MPC.OT, (Object[])new Object[]{string});
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange deleteMPC(@Nullable String string) {
        MPC mPC = (MPC)this.getOfID(string);
        if (mPC == null) {
            AuditHelper.onAuditDeleteFailure((ObjectType)MPC.OT, (Object[])new Object[]{"no-such-object-id", string});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.internalDeleteItem(string);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)MPC.OT, (Object[])new Object[]{string});
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IMPC getMPCOfID(@Nullable String string) {
        return (IMPC)this.getOfID(string);
    }
}

