/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.URLHelper;
import com.helger.phase4.model.ESoapVersion;
import java.io.Serializable;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeLegProtocol
implements Serializable {
    private String m_sAddress;
    private ESoapVersion m_eSoapVersion;

    public PModeLegProtocol() {
    }

    public PModeLegProtocol(@Nullable String string, @Nonnull ESoapVersion eSoapVersion) {
        this.setAddress(string);
        this.setSoapVersion(eSoapVersion);
    }

    @Nullable
    public final String getAddress() {
        return this.m_sAddress;
    }

    public final boolean hasAddress() {
        return StringHelper.hasText((String)this.m_sAddress);
    }

    @Nullable
    public final String getAddressProtocol() {
        URL uRL = URLHelper.getAsURL((String)this.m_sAddress);
        return uRL == null ? null : uRL.getProtocol();
    }

    @Nonnull
    public final EChange setAddress(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sAddress)) {
            return EChange.UNCHANGED;
        }
        this.m_sAddress = string;
        return EChange.CHANGED;
    }

    @Nonnull
    public final ESoapVersion getSoapVersion() {
        return this.m_eSoapVersion;
    }

    @Nonnull
    public final EChange setSoapVersion(@Nonnull ESoapVersion eSoapVersion) {
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        if (eSoapVersion.equals((Object)this.m_eSoapVersion)) {
            return EChange.UNCHANGED;
        }
        this.m_eSoapVersion = eSoapVersion;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeLegProtocol pModeLegProtocol = (PModeLegProtocol)object;
        return EqualsHelper.equals((Object)this.m_sAddress, (Object)pModeLegProtocol.m_sAddress) && this.m_eSoapVersion.equals((Object)pModeLegProtocol.m_eSoapVersion);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sAddress).append((Enum)this.m_eSoapVersion).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Address", (Object)this.m_sAddress).append("SoapVersion", (Enum)this.m_eSoapVersion).getToString();
    }

    @Nonnull
    public static PModeLegProtocol createForDefaultSoapVersion(@Nullable String string) {
        return new PModeLegProtocol(string, ESoapVersion.AS4_DEFAULT);
    }
}

