/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.name.IHasName;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EMandatory;
import com.helger.commons.state.IMandatoryIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModePayloadProfile
implements IHasName,
IMandatoryIndicator,
Serializable {
    public static final boolean DEFAULT_MANDATORY = false;
    private String m_sName;
    private IMimeType m_aMimeType;
    private String m_sXSDFilename;
    private Integer m_aMaxSizeKB;
    private EMandatory m_eMandatory;

    public PModePayloadProfile() {
    }

    public PModePayloadProfile(@Nonnull @Nonempty String string, @Nonnull IMimeType iMimeType, @Nullable String string2, @Nullable Integer n, @Nonnull EMandatory eMandatory) {
        this.setName(string);
        this.setMimeType(iMimeType);
        this.setXSDFilename(string2);
        this.setMaxSizeKB(n);
        this.setMandatory(eMandatory);
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Nonnull
    public final IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nonnull
    public final EChange setMimeType(@Nonnull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        if (iMimeType.equals((Object)this.m_aMimeType)) {
            return EChange.UNCHANGED;
        }
        this.m_aMimeType = iMimeType;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getXSDFilename() {
        return this.m_sXSDFilename;
    }

    public final boolean hasXSDFilename() {
        return StringHelper.hasText((String)this.m_sXSDFilename);
    }

    @Nonnull
    public final EChange setXSDFilename(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sXSDFilename)) {
            return EChange.UNCHANGED;
        }
        this.m_sXSDFilename = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final Integer getMaxSizeKB() {
        return this.m_aMaxSizeKB;
    }

    public final boolean hasMaxSizeKB() {
        return this.m_aMaxSizeKB != null;
    }

    @Nonnull
    public final EChange setMaxSizeKB(@Nullable Integer n) {
        if (EqualsHelper.equals((Object)n, (Object)this.m_aMaxSizeKB)) {
            return EChange.UNCHANGED;
        }
        this.m_aMaxSizeKB = n;
        return EChange.CHANGED;
    }

    @Nonnull
    public final EChange setMaxSizeKB(int n) {
        return this.setMaxSizeKB((Integer)n);
    }

    public final boolean isMandatory() {
        return this.m_eMandatory.isMandatory();
    }

    public final boolean isOptional() {
        return this.m_eMandatory.isOptional();
    }

    @Nonnull
    public final EChange setMandatory(@Nonnull EMandatory eMandatory) {
        ValueEnforcer.notNull((Object)eMandatory, (String)"Mandatory");
        if (eMandatory.equals((Object)this.m_eMandatory)) {
            return EChange.UNCHANGED;
        }
        this.m_eMandatory = eMandatory;
        return EChange.CHANGED;
    }

    @Nonnull
    public final EChange setMandatory(boolean bl) {
        return this.setMandatory(EMandatory.valueOf((boolean)bl));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModePayloadProfile pModePayloadProfile = (PModePayloadProfile)object;
        return this.m_sName.equals(pModePayloadProfile.m_sName) && this.m_aMimeType.equals((Object)pModePayloadProfile.m_aMimeType) && EqualsHelper.equals((Object)this.m_sXSDFilename, (Object)pModePayloadProfile.m_sXSDFilename) && EqualsHelper.equals((Object)this.m_aMaxSizeKB, (Object)pModePayloadProfile.m_aMaxSizeKB) && this.m_eMandatory.equals((Object)pModePayloadProfile.m_eMandatory);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sName).append((Object)this.m_aMimeType).append((Object)this.m_sXSDFilename).append((Object)this.m_aMaxSizeKB).append((Enum)this.m_eMandatory).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Name", (Object)this.m_sName).append("MimeType", (Object)this.m_aMimeType).append("XSDFilename", (Object)this.m_sXSDFilename).append("MaxSizeKB", (Object)this.m_aMaxSizeKB).append("Mandatory", (Enum)this.m_eMandatory).getToString();
    }
}

