/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.mime.MimeTypeParserException;
import com.helger.commons.state.EMandatory;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.leg.PModePayloadProfile;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModePayloadProfileJsonConverter {
    private static final String NAME = "Name";
    private static final String MIME_TYPE = "MimeType";
    private static final String XSD_FILENAME = "XSDFilename";
    private static final String MAX_SIZE_KB = "MaxSizeKB";
    private static final String MANDATORY = "Mandatory";

    private PModePayloadProfileJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModePayloadProfile pModePayloadProfile) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(NAME, (Object)pModePayloadProfile.getName());
        jsonObject.add(MIME_TYPE, (Object)pModePayloadProfile.getMimeType().getAsString());
        if (pModePayloadProfile.hasXSDFilename()) {
            jsonObject.add(XSD_FILENAME, (Object)pModePayloadProfile.getXSDFilename());
        }
        if (pModePayloadProfile.hasMaxSizeKB()) {
            jsonObject.add(MAX_SIZE_KB, pModePayloadProfile.getMaxSizeKB().intValue());
        }
        jsonObject.add(MANDATORY, pModePayloadProfile.isMandatory());
        return jsonObject;
    }

    @Nonnull
    public static PModePayloadProfile convertToNative(IJsonObject iJsonObject) {
        MimeType mimeType;
        String string = iJsonObject.getAsString((Object)NAME);
        String string2 = iJsonObject.getAsString((Object)MIME_TYPE);
        try {
            mimeType = MimeTypeParser.parseMimeType((String)string2);
        }
        catch (MimeTypeParserException mimeTypeParserException) {
            throw new IllegalArgumentException("Failed to parse MIME Type '" + string2 + "'", mimeTypeParserException);
        }
        String string3 = iJsonObject.getAsString((Object)XSD_FILENAME);
        Integer n = iJsonObject.getAsIntObj((Object)MAX_SIZE_KB);
        EMandatory eMandatory = EMandatory.valueOf((boolean)iJsonObject.getAsBoolean((Object)MANDATORY, false));
        return new PModePayloadProfile(string, (IMimeType)mimeType, string3, n, eMandatory);
    }
}

