/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.resolve;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.model.pmode.resolve.IAS4PModeResolver;
import com.helger.phase4.profile.IAS4Profile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4DefaultPModeResolver
implements IAS4PModeResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4DefaultPModeResolver.class);
    private final String m_sAS4ProfileID;
    private final IAS4Profile m_aAS4Profile;

    public AS4DefaultPModeResolver(@Nullable String string) {
        this.m_sAS4ProfileID = string;
        this.m_aAS4Profile = MetaAS4Manager.getProfileMgr().getProfileOfID(string);
        if (this.m_aAS4Profile == null && StringHelper.hasText((String)string)) {
            LOGGER.error("Failed to resolved the AS4 profile ID '" + string + "'");
        }
    }

    @Nullable
    public final String getAS4ProfileID() {
        return this.m_sAS4ProfileID;
    }

    @Nullable
    protected final IAS4Profile getAS4Profile() {
        return this.m_aAS4Profile;
    }

    @Nullable
    @OverrideOnDemand
    protected IPMode createDefaultPMode(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3) {
        if (this.m_aAS4Profile != null) {
            return this.m_aAS4Profile.createPModeTemplate(string, string2, string3);
        }
        return null;
    }

    @Override
    @Nullable
    public IPMode findPMode(@Nullable String string, @Nonnull String string2, @Nonnull String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5, @Nullable String string6, @Nullable String string7) {
        IPModeManager iPModeManager = MetaAS4Manager.getPModeMgr();
        IPMode iPMode = null;
        if (StringHelper.hasText((String)string) && (iPMode = iPModeManager.getPModeOfID(string)) != null) {
            return iPMode;
        }
        iPMode = iPModeManager.getPModeOfServiceAndAction(string2, string3);
        if (iPMode != null) {
            return iPMode;
        }
        return this.createDefaultPMode(string4, string5, string7);
    }

    public String toString() {
        return new ToStringGenerator(null).append("AS4ProfileID", (Object)this.m_sAS4ProfileID).getToString();
    }
}

