/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.profile.IAS4ProfileManager;
import com.helger.phase4.profile.IAS4ProfileRegistrarSPI;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AS4ProfileManager
implements IAS4ProfileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ProfileManager.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, IAS4Profile> m_aProfiles = new CommonsTreeMap();

    private void _registerAll() {
        this.m_aRWLock.writeLocked(() -> this.m_aProfiles.clear());
        for (IAS4ProfileRegistrarSPI iAS4ProfileRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IAS4ProfileRegistrarSPI.class)) {
            iAS4ProfileRegistrarSPI.registerAS4Profile(this);
        }
        int n = this.getProfileCount();
        if (n == 0) {
            LOGGER.warn("No AS4 profile is registered. This is most likely a configuration problem. Please make sure that at least one of the 'phase4-profile-*' modules is on the classpath.");
        } else {
            LOGGER.info((String)(n == 1 ? "1 AS4 profile is registered" : n + " AS4 profiles are registered") + ": " + String.valueOf(this.m_aProfiles.keySet()));
        }
    }

    public AS4ProfileManager() {
        this._registerAll();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAS4Profile> getAllProfiles() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aProfiles.copyOfValues());
    }

    @Nonnegative
    public final int getProfileCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aProfiles.size());
    }

    @Override
    @Nullable
    public IAS4Profile getProfileOfID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (IAS4Profile)this.m_aRWLock.readLockedGet(() -> (IAS4Profile)this.m_aProfiles.get((Object)string));
    }

    @Override
    public void registerProfile(@Nonnull IAS4Profile iAS4Profile) {
        ValueEnforcer.notNull((Object)iAS4Profile, (String)"AS4Profile");
        String string = (String)iAS4Profile.getID();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aProfiles.containsKey((Object)string)) {
                throw new IllegalStateException("An AS4 profile with ID '" + string + "' is already registered!");
            }
            this.m_aProfiles.put((Object)string, (Object)iAS4Profile);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered" + (iAS4Profile.isDeprecated() ? " deprecated" : "") + " AS4 profile '" + string + "'");
        }
    }

    public void reloadAll() {
        this._registerAll();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Profiles", this.m_aProfiles).getToString();
    }
}

