/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientSettings;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.crypto.AS4CryptParams;
import com.helger.phase4.crypto.AS4CryptoFactoryConfiguration;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.crypto.IAS4DecryptParameterModifier;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.incoming.AS4IncomingProfileSelectorConstant;
import com.helger.phase4.incoming.IAS4IncomingProfileSelector;
import com.helger.phase4.messaging.http.HttpRetrySettings;
import com.helger.phase4.messaging.http.IHttpPoster;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.pmode.resolve.AS4DefaultPModeResolver;
import com.helger.phase4.model.pmode.resolve.IAS4PModeResolver;
import com.helger.phase4.sender.IAS4RawResponseConsumer;
import com.helger.phase4.sender.IAS4SenderInterrupt;
import com.helger.phase4.sender.IAS4SendingDateTimeConsumer;
import com.helger.phase4.util.Phase4Exception;
import java.time.OffsetDateTime;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractAS4MessageBuilder<IMPLTYPE extends AbstractAS4MessageBuilder<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    public static final Locale DEFAULT_LOCALE = Locale.US;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS4MessageBuilder.class);
    protected IHttpPoster m_aCustomHttpPoster;
    protected HttpClientFactory m_aHttpClientFactory;
    protected IAS4CryptoFactory m_aCryptoFactorySign;
    protected IAS4CryptoFactory m_aCryptoFactoryCrypt;
    protected final AS4SigningParams m_aSigningParams = new AS4SigningParams();
    protected final AS4CryptParams m_aCryptParams = new AS4CryptParams();
    protected String m_sMessageID;
    protected String m_sRefToMessageID;
    protected OffsetDateTime m_aSendingDateTime;
    protected ESoapVersion m_eSoapVersion;
    protected HttpRetrySettings m_aHttpRetrySettings;
    protected Locale m_aLocale = DEFAULT_LOCALE;
    protected String m_sAS4ProfileID;
    private IAS4PModeResolver m_aPModeResolver;
    private IAS4IncomingAttachmentFactory m_aIAF;
    private IAS4IncomingProfileSelector m_aIncomingProfileSelector;
    private IAS4SenderInterrupt m_aSenderInterrupt;
    protected IAS4SendingDateTimeConsumer m_aSendingDTConsumer;
    protected IAS4ClientBuildMessageCallback m_aBuildMessageCallback;
    protected IAS4OutgoingDumper m_aOutgoingDumper;
    protected IAS4IncomingDumper m_aIncomingDumper;
    protected IAS4DecryptParameterModifier m_aDecryptParameterModifier;
    protected IAS4RetryCallback m_aRetryCallback;
    protected IAS4RawResponseConsumer m_aResponseConsumer;

    protected AbstractAS4MessageBuilder() {
        try {
            this.httpClientFactory(new HttpClientFactory());
            this.cryptoFactory(AS4CryptoFactoryConfiguration.getDefaultInstanceOrNull());
            this.soapVersion(ESoapVersion.SOAP_12);
            this.incomingAttachmentFactory(IAS4IncomingAttachmentFactory.DEFAULT_INSTANCE);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to init AbstractAS4MessageBuilder", exception);
        }
    }

    @Nullable
    public final IHttpPoster customHttpPoster() {
        return this.m_aCustomHttpPoster;
    }

    @Nonnull
    public final IMPLTYPE customHttpPoster(@Nullable IHttpPoster iHttpPoster) {
        this.m_aCustomHttpPoster = iHttpPoster;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final HttpClientFactory httpClientFactory() {
        return this.m_aHttpClientFactory;
    }

    @Nonnull
    public final IMPLTYPE httpClientFactory(@Nullable HttpClientSettings httpClientSettings) {
        return this.httpClientFactory(httpClientSettings == null ? null : new HttpClientFactory(httpClientSettings));
    }

    @Nonnull
    public final IMPLTYPE httpClientFactory(@Nullable HttpClientFactory httpClientFactory) {
        this.m_aHttpClientFactory = httpClientFactory;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4CryptoFactory cryptoFactorySign() {
        return this.m_aCryptoFactorySign;
    }

    @Nonnull
    public final IMPLTYPE cryptoFactorySign(@Nullable IAS4CryptoFactory iAS4CryptoFactory) {
        this.m_aCryptoFactorySign = iAS4CryptoFactory;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4CryptoFactory cryptoFactoryCrypt() {
        return this.m_aCryptoFactoryCrypt;
    }

    @Nonnull
    public final IMPLTYPE cryptoFactoryCrypt(@Nullable IAS4CryptoFactory iAS4CryptoFactory) {
        this.m_aCryptoFactoryCrypt = iAS4CryptoFactory;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE cryptoFactory(@Nullable IAS4CryptoFactory iAS4CryptoFactory) {
        return ((AbstractAS4MessageBuilder)this.cryptoFactorySign(iAS4CryptoFactory)).cryptoFactoryCrypt(iAS4CryptoFactory);
    }

    @Nonnull
    @ReturnsMutableObject
    public final AS4SigningParams signingParams() {
        return this.m_aSigningParams;
    }

    @Nonnull
    @ReturnsMutableObject
    public final IMPLTYPE withSigningParams(@Nonnull Consumer<? super AS4SigningParams> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        consumer.accept(this.m_aSigningParams);
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nonnull
    @ReturnsMutableObject
    public final AS4CryptParams cryptParams() {
        return this.m_aCryptParams;
    }

    @Nonnull
    @ReturnsMutableObject
    public final IMPLTYPE withCryptParams(@Nonnull Consumer<? super AS4CryptParams> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        consumer.accept(this.m_aCryptParams);
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final String messageID() {
        return this.m_sMessageID;
    }

    @Nonnull
    public final IMPLTYPE messageID(@Nullable String string) {
        this.m_sMessageID = string;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final String refToMessageID() {
        return this.m_sRefToMessageID;
    }

    @Nonnull
    public final IMPLTYPE refToMessageID(@Nullable String string) {
        this.m_sRefToMessageID = string;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final OffsetDateTime sendingDateTime() {
        return this.m_aSendingDateTime;
    }

    @Nonnull
    public final IMPLTYPE sendingDateTime(@Nullable OffsetDateTime offsetDateTime) {
        this.m_aSendingDateTime = offsetDateTime;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final ESoapVersion soapVersion() {
        return this.m_eSoapVersion;
    }

    @Nonnull
    public final IMPLTYPE soapVersion(@Nullable ESoapVersion eSoapVersion) {
        this.m_eSoapVersion = eSoapVersion;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final HttpRetrySettings httpRetrySettings() {
        return this.m_aHttpRetrySettings;
    }

    @Nonnull
    public final IMPLTYPE httpRetrySettings(@Nullable HttpRetrySettings httpRetrySettings) {
        this.m_aHttpRetrySettings = httpRetrySettings;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final Locale locale() {
        return this.m_aLocale;
    }

    @Nonnull
    public final IMPLTYPE locale(@Nullable Locale locale) {
        this.m_aLocale = locale;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final String as4ProfileID() {
        return this.m_sAS4ProfileID;
    }

    @Nonnull
    public final IMPLTYPE as4ProfileID(@Nullable String string) {
        this.m_sAS4ProfileID = string;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4PModeResolver pmodeResolver() {
        return this.m_aPModeResolver;
    }

    @Nonnull
    public final IMPLTYPE pmodeResolver(@Nullable IAS4PModeResolver iAS4PModeResolver) {
        this.m_aPModeResolver = iAS4PModeResolver;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IAS4IncomingAttachmentFactory incomingAttachmentFactory() {
        return this.m_aIAF;
    }

    @Nonnull
    public final IMPLTYPE incomingAttachmentFactory(@Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory) {
        ValueEnforcer.notNull((Object)iAS4IncomingAttachmentFactory, (String)"IncomingAttachmentFactory");
        this.m_aIAF = iAS4IncomingAttachmentFactory;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IAS4IncomingProfileSelector incomingProfileSelector() {
        return this.m_aIncomingProfileSelector;
    }

    @Nonnull
    public final IMPLTYPE incomingProfileSelector(@Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector) {
        ValueEnforcer.notNull((Object)iAS4IncomingProfileSelector, (String)"IncomingProfileSelector");
        this.m_aIncomingProfileSelector = iAS4IncomingProfileSelector;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4SenderInterrupt senderInterrupt() {
        return this.m_aSenderInterrupt;
    }

    @Nonnull
    public final IMPLTYPE senderInterrupt(@Nullable IAS4SenderInterrupt iAS4SenderInterrupt) {
        this.m_aSenderInterrupt = iAS4SenderInterrupt;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4SendingDateTimeConsumer sendingDateTimeConsumer() {
        return this.m_aSendingDTConsumer;
    }

    @Nonnull
    public final IMPLTYPE sendingDateTimeConsumer(@Nullable IAS4SendingDateTimeConsumer iAS4SendingDateTimeConsumer) {
        this.m_aSendingDTConsumer = iAS4SendingDateTimeConsumer;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4ClientBuildMessageCallback buildMessageCallback() {
        return this.m_aBuildMessageCallback;
    }

    @Nonnull
    public final IMPLTYPE buildMessageCallback(@Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback) {
        this.m_aBuildMessageCallback = iAS4ClientBuildMessageCallback;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4OutgoingDumper outgoingDumper() {
        return this.m_aOutgoingDumper;
    }

    @Nonnull
    public final IMPLTYPE outgoingDumper(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
        this.m_aOutgoingDumper = iAS4OutgoingDumper;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4IncomingDumper incomingDumper() {
        return this.m_aIncomingDumper;
    }

    @Nonnull
    public final IMPLTYPE incomingDumper(@Nullable IAS4IncomingDumper iAS4IncomingDumper) {
        this.m_aIncomingDumper = iAS4IncomingDumper;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4DecryptParameterModifier decryptRequestDataModifier() {
        return this.m_aDecryptParameterModifier;
    }

    @Nonnull
    public final IMPLTYPE decryptRequestDataModifier(@Nullable IAS4DecryptParameterModifier iAS4DecryptParameterModifier) {
        this.m_aDecryptParameterModifier = iAS4DecryptParameterModifier;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4RetryCallback retryCallback() {
        return this.m_aRetryCallback;
    }

    @Nonnull
    public final IMPLTYPE retryCallback(@Nullable IAS4RetryCallback iAS4RetryCallback) {
        this.m_aRetryCallback = iAS4RetryCallback;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4RawResponseConsumer rawResponseConsumer() {
        return this.m_aResponseConsumer;
    }

    @Nonnull
    public final IMPLTYPE rawResponseConsumer(@Nullable IAS4RawResponseConsumer iAS4RawResponseConsumer) {
        this.m_aResponseConsumer = iAS4RawResponseConsumer;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected ESuccess finishFields() throws Phase4Exception {
        if (StringHelper.hasText((String)this.m_sAS4ProfileID)) {
            if (this.m_aPModeResolver == null) {
                this.pmodeResolver(new AS4DefaultPModeResolver(this.m_sAS4ProfileID));
            }
            if (this.m_aIncomingProfileSelector == null) {
                this.incomingProfileSelector(new AS4IncomingProfileSelectorConstant(this.m_sAS4ProfileID));
            }
        }
        return ESuccess.SUCCESS;
    }

    @OverridingMethodsMustInvokeSuper
    public boolean isEveryRequiredFieldSet() {
        if (this.m_aHttpClientFactory == null) {
            LOGGER.warn("The field 'httpClientFactory' is not set");
            return false;
        }
        if (this.m_eSoapVersion == null) {
            LOGGER.warn("The field 'soapVersion' is not set");
            return false;
        }
        if (this.m_aLocale == null) {
            LOGGER.warn("The field 'locale' is not set");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sAS4ProfileID)) {
            LOGGER.warn("The field 'as4ProfileID' is not set");
            return false;
        }
        if (this.m_aPModeResolver == null) {
            LOGGER.warn("The field 'pmodeResolver' is not set");
            return false;
        }
        if (this.m_aIAF == null) {
            LOGGER.warn("The field 'incomingAttachmentFactory' is not set");
            return false;
        }
        return true;
    }

    @OverrideOnDemand
    protected void customizeBeforeSending() throws Phase4Exception {
    }

    protected abstract void mainSendMessage() throws Phase4Exception;

    @OverrideOnDemand
    protected void afterSuccessfulSending() {
    }

    @Nonnull
    public final ESuccess sendMessage() throws Phase4Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to send the AS4 message");
        }
        if (this.finishFields().isFailure()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("finishFields() prevented the AS4 message to be send");
            }
            return ESuccess.FAILURE;
        }
        if (!this.isEveryRequiredFieldSet()) {
            LOGGER.error("At least one mandatory field is not set and therefore the AS4 message cannot be send.");
            return ESuccess.FAILURE;
        }
        this.customizeBeforeSending();
        if (this.m_aSenderInterrupt != null && this.m_aSenderInterrupt.canSendDocument().isBreak()) {
            LOGGER.warn("The AS4 sender interrupt disabled the sending of the message.");
            return ESuccess.FAILURE;
        }
        this.mainSendMessage();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished main AS4 message sending without exception");
        }
        this.afterSuccessfulSending();
        return ESuccess.SUCCESS;
    }
}

