/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.client.AS4ClientPullRequestMessage;
import com.helger.phase4.incoming.AS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.IAS4SignalMessageConsumer;
import com.helger.phase4.incoming.IAS4UserMessageConsumer;
import com.helger.phase4.incoming.crypto.AS4IncomingSecurityConfiguration;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.sender.AS4BidirectionalClientHelper;
import com.helger.phase4.sender.AbstractAS4MessageBuilder;
import com.helger.phase4.sender.IAS4SignalMessageValidationResultHandler;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.Phase4Exception;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractAS4PullRequestBuilder<IMPLTYPE extends AbstractAS4PullRequestBuilder<IMPLTYPE>>
extends AbstractAS4MessageBuilder<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS4PullRequestBuilder.class);
    protected IPMode m_aPMode;
    protected String m_sPModeID;
    private boolean m_bUseLeg1 = true;
    protected String m_sMPC;
    protected String m_sEndpointURL;
    protected IAS4UserMessageConsumer m_aUserMsgConsumer;
    protected IAS4SignalMessageConsumer m_aSignalMsgConsumer;
    protected IAS4SignalMessageValidationResultHandler m_aSignalMsgValidationResultHdl;

    protected AbstractAS4PullRequestBuilder() {
    }

    @Nullable
    public final IPMode pmode() {
        return this.m_aPMode;
    }

    @Nonnull
    public final IMPLTYPE pmode(@Nullable IPMode iPMode) {
        if (iPMode == null) {
            LOGGER.warn("A null PMode was supplied");
        }
        this.m_aPMode = iPMode;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Nullable
    public final String pmodeID() {
        return this.m_sPModeID;
    }

    @Nonnull
    public final IMPLTYPE pmodeID(@Nullable String string) {
        this.m_sPModeID = string;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    public final boolean useLeg1() {
        return this.m_bUseLeg1;
    }

    @Nonnull
    public final IMPLTYPE useLeg1(boolean bl) {
        this.m_bUseLeg1 = bl;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Nullable
    public final String mpc() {
        return this.m_sMPC;
    }

    @Nonnull
    public final IMPLTYPE mpc(@Nullable String string) {
        this.m_sMPC = string;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Nullable
    public final String endpointURL() {
        return this.m_sEndpointURL;
    }

    @Nonnull
    public final IMPLTYPE endpointURL(@Nullable String string) {
        this.m_sEndpointURL = string;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4UserMessageConsumer userMsgConsumer() {
        return this.m_aUserMsgConsumer;
    }

    @Nonnull
    public final IMPLTYPE userMsgConsumer(@Nullable IAS4UserMessageConsumer iAS4UserMessageConsumer) {
        this.m_aUserMsgConsumer = iAS4UserMessageConsumer;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4SignalMessageConsumer signalMsgConsumer() {
        return this.m_aSignalMsgConsumer;
    }

    @Nonnull
    public final IMPLTYPE signalMsgConsumer(@Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer) {
        this.m_aSignalMsgConsumer = iAS4SignalMessageConsumer;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4SignalMessageValidationResultHandler signalMsgValidationResultHdl() {
        return this.m_aSignalMsgValidationResultHdl;
    }

    @Nonnull
    public final IMPLTYPE signalMsgValidationResultHdl(@Nullable IAS4SignalMessageValidationResultHandler iAS4SignalMessageValidationResultHandler) {
        this.m_aSignalMsgValidationResultHdl = iAS4SignalMessageValidationResultHandler;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    protected ESuccess finishFields() throws Phase4Exception {
        if (super.finishFields().isFailure()) {
            return ESuccess.FAILURE;
        }
        if (this.m_aPMode == null && this.pmodeResolver() != null) {
            this.m_aPMode = this.pmodeResolver().findPMode(this.m_sPModeID, "s", "a", "i", "r", "a", null);
            if (this.m_aPMode == null) {
                LOGGER.warn("No PMode was provided, and the PMode Resolver delivered a null-PMode as well");
            }
        }
        return ESuccess.SUCCESS;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEveryRequiredFieldSet() {
        if (!super.isEveryRequiredFieldSet()) {
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sMPC)) {
            LOGGER.warn("The field 'MPC' is not set");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sEndpointURL)) {
            LOGGER.warn("The field 'endpointURL' is not set");
            return false;
        }
        return true;
    }

    protected final void applyToPullRequest(@Nonnull AS4ClientPullRequestMessage aS4ClientPullRequestMessage) {
        if (this.m_aCustomHttpPoster != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using a custom IHttpPoster implementation: " + String.valueOf(this.m_aCustomHttpPoster));
            }
            aS4ClientPullRequestMessage.setHttpPoster(this.m_aCustomHttpPoster);
        } else {
            aS4ClientPullRequestMessage.getHttpPoster().setHttpClientFactory(this.m_aHttpClientFactory);
            aS4ClientPullRequestMessage.getHttpPoster().setQuoteHttpHeaders(false);
        }
        aS4ClientPullRequestMessage.setSoapVersion(this.m_eSoapVersion);
        aS4ClientPullRequestMessage.setSendingDateTime(this.m_aSendingDateTime);
        aS4ClientPullRequestMessage.setCryptoFactorySign(this.m_aCryptoFactorySign);
        aS4ClientPullRequestMessage.setCryptoFactoryCrypt(this.m_aCryptoFactoryCrypt);
        this.m_aCryptParams.cloneTo(aS4ClientPullRequestMessage.cryptParams());
        this.m_aSigningParams.cloneTo(aS4ClientPullRequestMessage.signingParams());
        if (this.m_aHttpRetrySettings != null) {
            aS4ClientPullRequestMessage.httpRetrySettings().assignFrom(this.m_aHttpRetrySettings);
        }
        if (StringHelper.hasText((String)this.m_sMessageID)) {
            aS4ClientPullRequestMessage.setMessageID(this.m_sMessageID);
        }
        if (StringHelper.hasText((String)this.m_sRefToMessageID)) {
            aS4ClientPullRequestMessage.setRefToMessageID(this.m_sRefToMessageID);
        }
        aS4ClientPullRequestMessage.setMPC(this.m_sMPC);
        if (this.m_aPMode != null) {
            PModeLeg pModeLeg = this.m_bUseLeg1 ? this.m_aPMode.getLeg1() : this.m_aPMode.getLeg2();
            aS4ClientPullRequestMessage.setValuesFromPMode(this.m_aPMode, pModeLeg);
        }
    }

    @Override
    protected final void mainSendMessage() throws Phase4Exception {
        try (AS4ResourceHelper aS4ResourceHelper = new AS4ResourceHelper();){
            AS4ClientPullRequestMessage aS4ClientPullRequestMessage = new AS4ClientPullRequestMessage(aS4ResourceHelper);
            this.applyToPullRequest(aS4ClientPullRequestMessage);
            if (this.m_aSendingDTConsumer != null) {
                try {
                    this.m_aSendingDTConsumer.onEffectiveSendingDateTime(((AS4ClientPullRequestMessage)aS4ClientPullRequestMessage.ensureSendingDateTime()).getSendingDateTime());
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to invoke IAS4SendingDateTimeConsumer", (Throwable)exception);
                }
            }
            AS4IncomingSecurityConfiguration aS4IncomingSecurityConfiguration = new AS4IncomingSecurityConfiguration().setSigningParams(this.m_aSigningParams.getClone()).setCryptParams(this.m_aCryptParams.getClone()).setDecryptParameterModifier(this.m_aDecryptParameterModifier);
            AS4IncomingReceiverConfiguration aS4IncomingReceiverConfiguration = new AS4IncomingReceiverConfiguration();
            AS4BidirectionalClientHelper.sendAS4PullRequestAndReceiveAS4UserOrSignalMessage(this.m_aCryptoFactorySign, this.m_aCryptoFactoryCrypt, this.pmodeResolver(), this.incomingAttachmentFactory(), this.incomingProfileSelector(), aS4ClientPullRequestMessage, this.m_aLocale, this.m_sEndpointURL, this.m_aBuildMessageCallback, this.m_aOutgoingDumper, this.m_aIncomingDumper, aS4IncomingSecurityConfiguration, aS4IncomingReceiverConfiguration, this.m_aRetryCallback, this.m_aResponseConsumer, this.m_aUserMsgConsumer, this.m_aSignalMsgConsumer, this.m_aSignalMsgValidationResultHdl, this.m_aPMode);
        }
        catch (Phase4Exception phase4Exception) {
            throw phase4Exception;
        }
        catch (Exception exception) {
            throw new Phase4Exception("Wrapped Phase4Exception", exception);
        }
    }
}

