/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.phase4.attachment.AS4OutgoingAttachment;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.AS4ClientUserMessage;
import com.helger.phase4.incoming.AS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.crypto.AS4IncomingSecurityConfiguration;
import com.helger.phase4.sender.AS4BidirectionalClientHelper;
import com.helger.phase4.sender.AbstractAS4UserMessageBuilder;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.Phase4Exception;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractAS4UserMessageBuilderMIMEPayload<IMPLTYPE extends AbstractAS4UserMessageBuilderMIMEPayload<IMPLTYPE>>
extends AbstractAS4UserMessageBuilder<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS4UserMessageBuilderMIMEPayload.class);
    protected AS4OutgoingAttachment m_aPayload;

    protected AbstractAS4UserMessageBuilderMIMEPayload() {
    }

    @Nullable
    public final AS4OutgoingAttachment payload() {
        return this.m_aPayload;
    }

    @Nonnull
    public final IMPLTYPE payload(@Nullable AS4OutgoingAttachment.Builder builder) {
        return this.payload(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE payload(@Nullable AS4OutgoingAttachment aS4OutgoingAttachment) {
        this.m_aPayload = aS4OutgoingAttachment;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilderMIMEPayload)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEveryRequiredFieldSet() {
        return super.isEveryRequiredFieldSet();
    }

    @Nullable
    @OverrideOnDemand
    protected WSS4JAttachment createMainAttachment(@Nonnull AS4OutgoingAttachment aS4OutgoingAttachment, @Nonnull AS4ResourceHelper aS4ResourceHelper) throws IOException {
        return WSS4JAttachment.createOutgoingFileAttachment(aS4OutgoingAttachment, aS4ResourceHelper);
    }

    @Nullable
    @OverrideOnDemand
    protected WSS4JAttachment createOtherAttachment(@Nonnull AS4OutgoingAttachment aS4OutgoingAttachment, @Nonnull AS4ResourceHelper aS4ResourceHelper, @Nonnegative int n) throws IOException {
        return WSS4JAttachment.createOutgoingFileAttachment(aS4OutgoingAttachment, aS4ResourceHelper);
    }

    @Override
    protected final void mainSendMessage() throws Phase4Exception {
        try (AS4ResourceHelper aS4ResourceHelper = new AS4ResourceHelper();){
            WSS4JAttachment wSS4JAttachment;
            AS4ClientUserMessage aS4ClientUserMessage = new AS4ClientUserMessage(aS4ResourceHelper);
            this.applyToUserMessage(aS4ClientUserMessage);
            if (this.m_aSendingDTConsumer != null) {
                try {
                    this.m_aSendingDTConsumer.onEffectiveSendingDateTime(((AS4ClientUserMessage)aS4ClientUserMessage.ensureSendingDateTime()).getSendingDateTime());
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to invoke IAS4SendingDateTimeConsumer", (Throwable)exception);
                }
            }
            aS4ClientUserMessage.setPayload(null);
            if (this.m_aPayload != null && (wSS4JAttachment = this.createMainAttachment(this.m_aPayload, aS4ResourceHelper)) != null) {
                aS4ClientUserMessage.addAttachment(wSS4JAttachment);
            }
            int n = 0;
            for (AS4OutgoingAttachment aS4OutgoingAttachment : this.m_aAttachments) {
                WSS4JAttachment wSS4JAttachment2 = this.createOtherAttachment(aS4OutgoingAttachment, aS4ResourceHelper, n);
                if (wSS4JAttachment2 != null) {
                    aS4ClientUserMessage.addAttachment(wSS4JAttachment2);
                }
                ++n;
            }
            AS4IncomingSecurityConfiguration aS4IncomingSecurityConfiguration = new AS4IncomingSecurityConfiguration().setSigningParams(this.m_aSigningParams.getClone()).setCryptParams(this.m_aCryptParams.getClone()).setDecryptParameterModifier(this.m_aDecryptParameterModifier);
            AS4IncomingReceiverConfiguration aS4IncomingReceiverConfiguration = new AS4IncomingReceiverConfiguration();
            AS4BidirectionalClientHelper.sendAS4UserMessageAndReceiveAS4SignalMessage(this.m_aCryptoFactorySign, this.m_aCryptoFactoryCrypt, this.pmodeResolver(), this.incomingAttachmentFactory(), this.incomingProfileSelector(), aS4ClientUserMessage, this.m_aLocale, this.m_sEndpointURL, this.m_aBuildMessageCallback, this.m_aOutgoingDumper, this.m_aIncomingDumper, aS4IncomingSecurityConfiguration, aS4IncomingReceiverConfiguration, this.m_aRetryCallback, this.m_aResponseConsumer, this.m_aSignalMsgConsumer, this.m_aSignalMsgValidationResultHdl);
        }
        catch (Phase4Exception phase4Exception) {
            throw phase4Exception;
        }
        catch (Exception exception) {
            throw new Phase4Exception("Wrapped Phase4Exception", exception);
        }
    }
}

