/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.ValueEnforcer;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.MessagePartNRInformation;
import com.helger.phase4.ebms3header.NonRepudiationInformation;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.incoming.IAS4SignalMessageConsumer;
import com.helger.phase4.sender.IAS4SignalMessageValidationResultHandler;
import com.helger.phase4.sender.LoggingAS4SignalMsgValidationResultHandler;
import com.helger.phase4.util.Phase4Exception;
import com.helger.xsds.xmldsig.ReferenceType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ValidatingAS4SignalMsgConsumer
implements IAS4SignalMessageConsumer {
    private static final IAS4SignalMessageValidationResultHandler DEFAULT_RES_HDL = new LoggingAS4SignalMsgValidationResultHandler();
    private final AS4ClientSentMessage<?> m_aClientSetMsg;
    private final IAS4SignalMessageConsumer m_aOriginalConsumer;
    private final IAS4SignalMessageValidationResultHandler m_aResultHandler;

    public ValidatingAS4SignalMsgConsumer(@Nonnull AS4ClientSentMessage<?> aS4ClientSentMessage, @Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer, @Nullable IAS4SignalMessageValidationResultHandler iAS4SignalMessageValidationResultHandler) {
        ValueEnforcer.notNull(aS4ClientSentMessage, (String)"ClientSetMsg");
        this.m_aClientSetMsg = aS4ClientSentMessage;
        this.m_aOriginalConsumer = iAS4SignalMessageConsumer;
        this.m_aResultHandler = iAS4SignalMessageValidationResultHandler != null ? iAS4SignalMessageValidationResultHandler : DEFAULT_RES_HDL;
    }

    @Override
    public void handleSignalMessage(@Nonnull Ebms3SignalMessage ebms3SignalMessage, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState) throws Phase4Exception {
        boolean bl = false;
        if (this.m_aClientSetMsg.getBuiltMessage().hasDSReferences() && ebms3SignalMessage != null && ebms3SignalMessage.getReceipt() != null && ebms3SignalMessage.getReceipt().hasAnyEntries()) {
            NonRepudiationInformation nonRepudiationInformation = null;
            List<Object> list = ebms3SignalMessage.getReceipt().getAny();
            for (Object iterator : list) {
                if (!(iterator instanceof NonRepudiationInformation)) continue;
                nonRepudiationInformation = (NonRepudiationInformation)iterator;
                break;
            }
            if (nonRepudiationInformation != null) {
                bl = true;
                Iterator<Object> iterator = this.m_aClientSetMsg.getBuiltMessage().getAllDSReferences();
                if (iterator.size() != nonRepudiationInformation.getMessagePartNRInformationCount()) {
                    this.m_aResultHandler.onError("The UserMessage sent out contains " + iterator.size() + " DSig references, wheres the received Receipt contains " + nonRepudiationInformation.getMessagePartNRInformationCount() + " DSig references. This will lead to follow-up errors.");
                }
                for (MessagePartNRInformation messagePartNRInformation : nonRepudiationInformation.getMessagePartNRInformation()) {
                    ReferenceType referenceType = messagePartNRInformation.getReference();
                    if (!iterator.removeObject(referenceType).isUnchanged()) continue;
                    this.m_aResultHandler.onError("The received DSig reference was not found in the source list: " + String.valueOf(referenceType));
                }
                if (iterator.isNotEmpty()) {
                    this.m_aResultHandler.onError("No all sent DSig references were found in the received AS4 Receipt message");
                } else {
                    this.m_aResultHandler.onSuccess();
                }
            }
        }
        if (!bl) {
            this.m_aResultHandler.onNotApplicable();
        }
        if (this.m_aOriginalConsumer != null) {
            this.m_aOriginalConsumer.handleSignalMessage(ebms3SignalMessage, iAS4IncomingMessageMetadata, iAS4IncomingMessageState);
        }
    }
}

