/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.wss;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.functional.IThrowingSupplier;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.wss4j.dom.engine.WSSConfig;

@ThreadSafe
public final class WSSSynchronizer {
    private static final Lock LOCK = new ReentrantLock();

    private WSSSynchronizer() {
    }

    public static void run(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull((Object)runnable, (String)"Runnable");
        WSSSynchronizer.call(() -> {
            runnable.run();
            return null;
        });
    }

    @Nullable
    public static <T, EX extends Exception> T call(@Nonnull IThrowingSupplier<T, EX> iThrowingSupplier) throws EX {
        ValueEnforcer.notNull(iThrowingSupplier, (String)"Supplier");
        LOCK.lock();
        try {
            Object object;
            WSSConfig.init();
            try {
                object = iThrowingSupplier.get();
            }
            catch (Throwable throwable) {
                WSSConfig.cleanUp();
                throw throwable;
            }
            WSSConfig.cleanUp();
            return (T)object;
        }
        finally {
            LOCK.unlock();
        }
    }
}

