/*
 * Copyright (C) 2015-2025 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.phase4.sender;

import java.time.OffsetDateTime;

import jakarta.annotation.Nonnull;

/**
 * A specific callback interface to get the effective sending date time
 *
 * @author Philip Helger
 * @since 2.2.2
 */
@FunctionalInterface
public interface IAS4SendingDateTimeConsumer
{
  /**
   * Callback to do something with the sending date time
   *
   * @param aSendingDT
   *        The effective sending date time used. Never <code>null</code>.
   */
  void onEffectiveSendingDateTime (@Nonnull OffsetDateTime aSendingDT);
}
