/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.string.StringHelper;
import com.helger.mime.CMimeType;
import com.helger.mime.IMimeType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EAS4CompressionMode implements IHasID<String>
{
    GZIP("gzip", CMimeType.APPLICATION_GZIP, ".gz"){

        @Override
        @Nonnull
        public InputStream getDecompressStream(@Nonnull InputStream inputStream) throws IOException {
            return new GZIPInputStream(inputStream);
        }

        @Override
        @Nonnull
        public OutputStream getCompressStream(@Nonnull OutputStream outputStream) throws IOException {
            return new GZIPOutputStream(outputStream);
        }
    };

    private final String m_sID;
    private final IMimeType m_aMimeType;
    private final String m_sFileExtension;

    private EAS4CompressionMode(@Nonnull @Nonempty String string2, IMimeType iMimeType, String string3) {
        this.m_sID = string2;
        this.m_aMimeType = iMimeType;
        this.m_sFileExtension = string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nonnull
    @Nonempty
    public String getMimeTypeAsString() {
        return this.m_aMimeType.getAsString();
    }

    @Nonnull
    @Nonempty
    public String getFileExtension() {
        return this.m_sFileExtension;
    }

    @Nonnull
    public abstract InputStream getDecompressStream(@Nonnull InputStream var1) throws IOException;

    @Nonnull
    public abstract OutputStream getCompressStream(@Nonnull OutputStream var1) throws IOException;

    @Nullable
    public static EAS4CompressionMode getFromMimeTypeStringOrNull(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (EAS4CompressionMode)EnumHelper.findFirst(EAS4CompressionMode.class, eAS4CompressionMode -> eAS4CompressionMode.getMimeTypeAsString().equals(string));
    }

    @Nullable
    public static EAS4CompressionMode getFromIDOrNull(String string) {
        return (EAS4CompressionMode)EnumHelper.getFromIDOrNull(EAS4CompressionMode.class, (Object)string);
    }
}

