/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.io.stream.WrappedInputStream;
import com.helger.base.wrapper.Wrapper;
import com.helger.http.header.HttpHeaderMap;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@ThreadSafe
public final class AS4DumpManager {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IAS4IncomingDumper s_aIncomingDumper;
    @GuardedBy(value="RW_LOCK")
    private static IAS4OutgoingDumper s_aOutgoingDumper;

    private AS4DumpManager() {
    }

    @Nullable
    public static IAS4IncomingDumper getIncomingDumper() {
        return (IAS4IncomingDumper)RW_LOCK.readLockedGet(() -> s_aIncomingDumper);
    }

    public static void setIncomingDumper(@Nullable IAS4IncomingDumper iAS4IncomingDumper) {
        RW_LOCK.writeLocked(() -> {
            s_aIncomingDumper = iAS4IncomingDumper;
        });
    }

    @Nullable
    public static IAS4OutgoingDumper getOutgoingDumper() {
        return (IAS4OutgoingDumper)RW_LOCK.readLockedGet(() -> s_aOutgoingDumper);
    }

    public static void setOutgoingDumper(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
        RW_LOCK.writeLocked(() -> {
            s_aOutgoingDumper = iAS4OutgoingDumper;
        });
    }

    @Nonnull
    public static InputStream getIncomingDumpAwareInputStream(@Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull @WillNotClose InputStream inputStream, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Wrapper<OutputStream> wrapper) throws IOException {
        if (iAS4IncomingDumper == null) {
            return inputStream;
        }
        final OutputStream outputStream = iAS4IncomingDumper.onNewRequest(iAS4IncomingMessageMetadata, httpHeaderMap);
        if (outputStream == null) {
            return inputStream;
        }
        wrapper.set((Object)outputStream);
        return new WrappedInputStream(inputStream){
            private boolean m_bClosed;
            {
                super(inputStream);
                this.m_bClosed = false;
            }

            public int read() throws IOException {
                int n = super.read();
                if (n != -1) {
                    outputStream.write(n & 0xFF);
                }
                return n;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 != -1) {
                    outputStream.write(byArray, n, n3);
                }
                return n3;
            }

            public void close() throws IOException {
                if (!this.m_bClosed) {
                    try {
                        StreamHelper.flush((Flushable)outputStream);
                        StreamHelper.close((AutoCloseable)outputStream);
                        this.m_bClosed = true;
                    }
                    finally {
                        super.close();
                    }
                }
            }
        };
    }
}

