/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.spi;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.state.ISuccessIndicator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.phase4.attachment.WSS4JAttachment;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;

@Immutable
public class AS4MessageProcessorResult
implements ISuccessIndicator {
    private final ESuccess m_eSuccess;
    private final ICommonsList<WSS4JAttachment> m_aAttachments;
    private final String m_sAsyncResponseURL;

    protected AS4MessageProcessorResult(@Nonnull ESuccess eSuccess, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable String string) {
        ValueEnforcer.notNull((Object)eSuccess, (String)"Success");
        this.m_eSuccess = eSuccess;
        this.m_aAttachments = iCommonsList;
        this.m_sAsyncResponseURL = string;
    }

    public boolean isSuccess() {
        return this.m_eSuccess.isSuccess();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WSS4JAttachment> getAllAttachments() {
        return new CommonsArrayList(this.m_aAttachments);
    }

    public boolean hasAttachments() {
        return CollectionHelper.isNotEmpty(this.m_aAttachments);
    }

    public void addAllAttachmentsTo(@Nonnull Collection<? super WSS4JAttachment> collection) {
        if (this.m_aAttachments != null) {
            collection.addAll((Collection<? super WSS4JAttachment>)this.m_aAttachments);
        }
    }

    @Nullable
    public String getAsyncResponseURL() {
        return this.m_sAsyncResponseURL;
    }

    public boolean hasAsyncResponseURL() {
        return StringHelper.isNotEmpty((String)this.m_sAsyncResponseURL);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Success", (Enum)this.m_eSuccess).appendIf("Attachments", this.m_aAttachments, () -> ((ESuccess)this.m_eSuccess).isSuccess()).appendIfNotNull("AsyncResponseURL", (Object)this.m_sAsyncResponseURL).getToString();
    }

    @Nonnull
    public static AS4MessageProcessorResult createSuccess() {
        return AS4MessageProcessorResult.createSuccessExt(null, null);
    }

    @Nonnull
    public static AS4MessageProcessorResult createSuccessExt(@Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable String string) {
        return new AS4MessageProcessorResult(ESuccess.SUCCESS, iCommonsList, string);
    }

    @Nonnull
    public static AS4MessageProcessorResult createFailure() {
        return new AS4MessageProcessorResult(ESuccess.FAILURE, (ICommonsList<WSS4JAttachment>)((ICommonsList)null), null);
    }
}

