/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.state.ESuccess;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.config.IConfig;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.httpclient.HttpClientSettings;
import com.helger.mime.CMimeType;
import com.helger.mime.IMimeType;
import com.helger.peppol.reporting.api.PeppolReportingHelper;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.reporting.api.backend.PeppolReportingBackend;
import com.helger.peppol.reporting.api.backend.PeppolReportingBackendException;
import com.helger.peppol.sbdh.EPeppolMLSType;
import com.helger.peppol.sbdh.PeppolSBDHData;
import com.helger.peppol.sbdh.PeppolSBDHDataWriter;
import com.helger.peppol.sbdh.payload.PeppolSBDHPayloadBinaryMarshaller;
import com.helger.peppol.sbdh.payload.PeppolSBDHPayloadTextMarshaller;
import com.helger.peppol.sbdh.spec12.BinaryContentType;
import com.helger.peppol.sbdh.spec12.TextContentType;
import com.helger.peppol.security.PeppolTrustedCA;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.peppol.doctype.PeppolDocumentTypeIdentifierParts;
import com.helger.phase4.attachment.AS4OutgoingAttachment;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.dynamicdiscovery.AS4EndpointDetailProviderConstant;
import com.helger.phase4.dynamicdiscovery.AS4EndpointDetailProviderPeppol;
import com.helger.phase4.dynamicdiscovery.IAS4EndpointDetailProvider;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.MessageProperty;
import com.helger.phase4.peppol.IPhase4PeppolCertificateCheckResultHandler;
import com.helger.phase4.peppol.IPhase4PeppolValidationResultHandler;
import com.helger.phase4.peppol.Phase4PeppolException;
import com.helger.phase4.peppol.Phase4PeppolValidation;
import com.helger.phase4.peppol.Phase4PeppolValidatonResultHandler;
import com.helger.phase4.profile.peppol.PeppolPMode;
import com.helger.phase4.profile.peppol.Phase4PeppolHttpClientSettings;
import com.helger.phase4.sender.AbstractAS4UserMessageBuilderMIMEPayload;
import com.helger.phase4.sender.IAS4SendingDateTimeConsumer;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.Phase4Exception;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.sbdh.SBDMarshaller;
import com.helger.security.certificate.CertificateHelper;
import com.helger.security.certificate.ECertificateCheckResult;
import com.helger.security.certificate.TrustedCAChecker;
import com.helger.security.revocation.ERevocationCheckMode;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.smpclient.url.IPeppolURLProvider;
import com.helger.smpclient.url.PeppolConfigurableURLProvider;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xsds.peppol.smp1.EndpointType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.unece.cefact.namespaces.sbdh.Scope;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Immutable
public final class Phase4PeppolSender {
    public static final PeppolIdentifierFactory IF = PeppolIdentifierFactory.INSTANCE;
    public static final IPeppolURLProvider URL_PROVIDER = PeppolConfigurableURLProvider.INSTANCE;
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(Phase4PeppolSender.class);

    private Phase4PeppolSender() {
    }

    @Nullable
    private static PeppolSBDHData _createPeppolSBDHData(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nonnull Element element, boolean bl) {
        Object object;
        PeppolSBDHData peppolSBDHData = new PeppolSBDHData((IIdentifierFactory)IF);
        peppolSBDHData.setSender(iParticipantIdentifier);
        peppolSBDHData.setReceiver(iParticipantIdentifier2);
        peppolSBDHData.setDocumentType(iDocumentTypeIdentifier);
        peppolSBDHData.setProcess(iProcessIdentifier);
        peppolSBDHData.setCountryC1(string);
        String string6 = string3;
        if (StringHelper.isEmpty((String)string6)) {
            string6 = element.getNamespaceURI();
        }
        if (StringHelper.isEmpty((String)string6)) {
            LOGGER.warn("No Standard was provided and none could be deduced from the payload element (XML payloads without namespace URI are not permitted)");
            return null;
        }
        String string7 = string4;
        if (StringHelper.isEmpty((String)string7)) {
            try {
                object = PeppolDocumentTypeIdentifierParts.extractFromIdentifier((IDocumentTypeIdentifier)iDocumentTypeIdentifier);
                string7 = object.getVersion();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (StringHelper.isEmpty((String)string7)) {
            LOGGER.warn("No TypeVersion was provided and none could be deduced from the document type identifier '" + iDocumentTypeIdentifier.getURIEncoded() + "'");
            return null;
        }
        object = string5;
        if (StringHelper.isEmpty((String)object)) {
            object = element.getLocalName();
        }
        if (StringHelper.isEmpty((String)object)) {
            LOGGER.warn("No Type was provided and none could be deduced from the payload element");
            return null;
        }
        String string8 = string2;
        if (StringHelper.isEmpty((String)string8)) {
            string8 = UUID.randomUUID().toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("As no SBDH InstanceIdentifier was provided, a random one was created: '" + string8 + "'");
            }
        }
        peppolSBDHData.setDocumentIdentification(string6, string7, (String)object, string8, MetaAS4Manager.getTimestampMgr().getCurrentXMLDateTime());
        if (bl) {
            peppolSBDHData.setBusinessMessage(element);
        } else {
            peppolSBDHData.setBusinessMessageNoClone(element);
        }
        if (!peppolSBDHData.areAllFieldsSet(true)) {
            throw new IllegalArgumentException("The Peppol SBDH data is incomplete. See logs for details.");
        }
        return peppolSBDHData;
    }

    @Nullable
    private static StandardBusinessDocument _createSBD(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nonnull Element element, boolean bl) {
        PeppolSBDHData peppolSBDHData = Phase4PeppolSender._createPeppolSBDHData(iParticipantIdentifier, iParticipantIdentifier2, iDocumentTypeIdentifier, iProcessIdentifier, string, string2, string3, string4, string5, element, bl);
        if (peppolSBDHData == null) {
            return null;
        }
        return new PeppolSBDHDataWriter().setFavourSpeed(true).createStandardBusinessDocument(peppolSBDHData);
    }

    @Nullable
    public static StandardBusinessDocument createSBDH(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nonnull Element element) {
        return Phase4PeppolSender._createSBD(iParticipantIdentifier, iParticipantIdentifier2, iDocumentTypeIdentifier, iProcessIdentifier, string, string2, string3, string4, string5, element, true);
    }

    private static void _validatePayload(@Nonnull Element element, @Nullable IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry, @Nullable DVRCoordinate dVRCoordinate, @Nullable IPhase4PeppolValidationResultHandler iPhase4PeppolValidationResultHandler) throws Phase4Exception {
        if (dVRCoordinate != null) {
            if (iPhase4PeppolValidationResultHandler != null) {
                if (iValidationExecutorSetRegistry == null) {
                    Phase4PeppolValidation.validateOutgoingBusinessDocument(element, dVRCoordinate, iPhase4PeppolValidationResultHandler);
                } else {
                    Phase4PeppolValidation.validateOutgoingBusinessDocument(element, iValidationExecutorSetRegistry, dVRCoordinate, iPhase4PeppolValidationResultHandler);
                }
            } else {
                LOGGER.warn("A VES ID is present but no ValidationResultHandler - therefore no validation is performed");
            }
        } else if (iPhase4PeppolValidationResultHandler != null) {
            LOGGER.warn("A ValidationResultHandler is present but no VESID - therefore no validation is performed");
        }
    }

    private static void _checkReceiverAPCert(@Nonnull TrustedCAChecker trustedCAChecker, @Nullable X509Certificate x509Certificate, @Nullable IPhase4PeppolCertificateCheckResultHandler iPhase4PeppolCertificateCheckResultHandler, @Nonnull ETriState eTriState, @Nullable ERevocationCheckMode eRevocationCheckMode) throws Phase4Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using the following receiver AP certificate from the SMP: " + String.valueOf(x509Certificate));
        }
        OffsetDateTime offsetDateTime = MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
        ECertificateCheckResult eCertificateCheckResult = trustedCAChecker.checkCertificate(x509Certificate, offsetDateTime, eTriState, eRevocationCheckMode);
        if (iPhase4PeppolCertificateCheckResultHandler != null) {
            iPhase4PeppolCertificateCheckResultHandler.onCertificateCheckResult(x509Certificate, offsetDateTime, eCertificateCheckResult);
        }
        if (eCertificateCheckResult.isInvalid()) {
            String string = "The configured receiver AP certificate is not valid (at " + String.valueOf(offsetDateTime) + ") and cannot be used for sending towards. Aborting. Reason: " + eCertificateCheckResult.getReason();
            LOGGER.error(string);
            throw new Phase4PeppolException(string).setRetryFeasible(false);
        }
    }

    @Nonnull
    public static PeppolUserMessageBuilder builder() {
        return new PeppolUserMessageBuilder();
    }

    @Nonnull
    public static PeppolUserMessageSBDHBuilder sbdhBuilder() {
        return new PeppolUserMessageSBDHBuilder();
    }

    @NotThreadSafe
    public static class PeppolUserMessageBuilder
    extends AbstractPeppolUserMessageBuilder<PeppolUserMessageBuilder> {
        private String m_sSBDHInstanceIdentifier;
        private String m_sSBDHStandard;
        private String m_sSBDHTypeVersion;
        private String m_sSBDHType;
        private IParticipantIdentifier m_aMLSTo;
        private EPeppolMLSType m_eMLSType;
        private Element m_aPayloadElement;
        private byte[] m_aPayloadBytes;
        private IHasInputStream m_aPayloadHasIS;
        private Consumer<? super StandardBusinessDocument> m_aSBDDocumentConsumer;
        private IValidationExecutorSetRegistry<IValidationSourceXML> m_aVESRegistry;
        private DVRCoordinate m_aVESID;
        private IPhase4PeppolValidationResultHandler m_aValidationResultHandler;

        @Nonnull
        public PeppolUserMessageBuilder sbdhInstanceIdentifier(@Nullable String string) {
            this.m_sSBDHInstanceIdentifier = string;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder sbdhStandard(@Nullable String string) {
            this.m_sSBDHStandard = string;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder sbdhTypeVersion(@Nullable String string) {
            this.m_sSBDHTypeVersion = string;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder sbdhType(@Nullable String string) {
            this.m_sSBDHType = string;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder mlsTo(@Nullable IParticipantIdentifier iParticipantIdentifier) {
            this.m_aMLSTo = iParticipantIdentifier;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder mlsType(@Nullable EPeppolMLSType ePeppolMLSType) {
            this.m_eMLSType = ePeppolMLSType;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder payload(@Nonnull Element element) {
            ValueEnforcer.notNull((Object)element, (String)"Payload");
            ValueEnforcer.notNull((Object)element.getNamespaceURI(), (String)"Payload.NamespaceURI");
            this.m_aPayloadElement = element;
            this.m_aPayloadBytes = null;
            this.m_aPayloadHasIS = null;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder payload(@Nonnull byte[] byArray) {
            ValueEnforcer.notNull((Object)byArray, (String)"PayloadBytes");
            this.m_aPayloadElement = null;
            this.m_aPayloadBytes = byArray;
            this.m_aPayloadHasIS = null;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder payload(@Nonnull IHasInputStream iHasInputStream) {
            ValueEnforcer.notNull((Object)iHasInputStream, (String)"PayloadHasIS");
            this.m_aPayloadElement = null;
            this.m_aPayloadBytes = null;
            this.m_aPayloadHasIS = iHasInputStream;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder payloadBinaryContent(@Nonnull byte[] byArray, @Nonnull IMimeType iMimeType, @Nullable Charset charset) {
            ValueEnforcer.notNull((Object)byArray, (String)"BinaryPayload");
            ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
            BinaryContentType binaryContentType = new BinaryContentType();
            binaryContentType.setValue(byArray);
            binaryContentType.setMimeType(iMimeType.getAsString());
            binaryContentType.setEncoding(charset == null ? null : charset.name());
            Element element = new PeppolSBDHPayloadBinaryMarshaller().getAsElement((Object)binaryContentType);
            if (element == null) {
                throw new IllegalStateException("Failed to create 'BinaryContent' element.");
            }
            return this.payload(element);
        }

        @Nonnull
        public PeppolUserMessageBuilder payloadTextContent(@Nonnull String string, @Nonnull IMimeType iMimeType) {
            ValueEnforcer.notNull((Object)string, (String)"TextPayload");
            ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
            TextContentType textContentType = new TextContentType();
            textContentType.setValue(string);
            textContentType.setMimeType(iMimeType.getAsString());
            Element element = new PeppolSBDHPayloadTextMarshaller().getAsElement((Object)textContentType);
            if (element == null) {
                throw new IllegalStateException("Failed to create 'TextContent' element.");
            }
            return this.payload(element);
        }

        @Nonnull
        public PeppolUserMessageBuilder sbdDocumentConsumer(@Nullable Consumer<? super StandardBusinessDocument> consumer) {
            this.m_aSBDDocumentConsumer = consumer;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder validationRegistry(@Nullable IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
            this.m_aVESRegistry = iValidationExecutorSetRegistry;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder validationConfiguration(@Nullable DVRCoordinate dVRCoordinate) {
            Phase4PeppolValidatonResultHandler phase4PeppolValidatonResultHandler = dVRCoordinate == null ? null : new Phase4PeppolValidatonResultHandler();
            return this.validationConfiguration(dVRCoordinate, phase4PeppolValidatonResultHandler);
        }

        @Nonnull
        public PeppolUserMessageBuilder validationConfiguration(@Nullable DVRCoordinate dVRCoordinate, @Nullable IPhase4PeppolValidationResultHandler iPhase4PeppolValidationResultHandler) {
            this.m_aVESID = dVRCoordinate;
            this.m_aValidationResultHandler = iPhase4PeppolValidationResultHandler;
            return this;
        }

        @Nonnull
        public PeppolUserMessageBuilder disableValidation() {
            return this.validationConfiguration(null, null);
        }

        @Override
        protected ESuccess finishFields(@Nonnull AS4ResourceHelper aS4ResourceHelper) throws Phase4Exception {
            Document document;
            Object object;
            boolean bl;
            Element element;
            if (this.m_aPayloadElement != null) {
                element = this.m_aPayloadElement;
                bl = true;
            } else {
                if (this.m_aPayloadBytes != null) {
                    object = DOMReader.readXMLDOM((byte[])this.m_aPayloadBytes);
                    if (object == null) {
                        throw new Phase4PeppolException("Failed to parse payload bytes to a DOM node").setRetryFeasible(false);
                    }
                    element = object.getDocumentElement();
                } else if (this.m_aPayloadHasIS != null) {
                    object = this.m_aPayloadHasIS.getBufferedInputStream();
                    if (object == null) {
                        throw new Phase4PeppolException("Failed to create payload InputStream from provider").setRetryFeasible(false);
                    }
                    document = DOMReader.readXMLDOM((InputStream)object);
                    if (document == null) {
                        throw new Phase4PeppolException("Failed to parse payload InputStream to a DOM node").setRetryFeasible(false);
                    }
                    element = document.getDocumentElement();
                } else {
                    throw new IllegalStateException("Unexpected - neither element nor bytes nor InputStream provider are present");
                }
                if (element == null) {
                    throw new Phase4PeppolException("The parsed XML document must have a root element").setRetryFeasible(false);
                }
                if (element.getNamespaceURI() == null) {
                    throw new Phase4PeppolException("The root element of the parsed XML document does not have a namespace URI").setRetryFeasible(false);
                }
                bl = false;
            }
            if ("http://www.unece.org/cefact/namespaces/StandardBusinessDocumentHeader".equals(element.getNamespaceURI())) {
                throw new Phase4PeppolException("You cannot set a Standard Business Document as the payload for the regular builder. The SBD is created automatically inside of this builder. Use Phase4PeppolSender.sbdhBuilder() if you have a pre-build SBD.").setRetryFeasible(false);
            }
            Phase4PeppolSender._validatePayload(element, this.m_aVESRegistry, this.m_aVESID, this.m_aValidationResultHandler);
            if (super.finishFields(aS4ResourceHelper).isFailure()) {
                return ESuccess.FAILURE;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start creating SBDH for AS4 message");
            }
            if ((object = Phase4PeppolSender._createPeppolSBDHData(this.m_aSenderID, this.m_aReceiverID, this.m_aDocTypeID, this.m_aProcessID, this.m_sCountryC1, this.m_sSBDHInstanceIdentifier, this.m_sSBDHStandard, this.m_sSBDHTypeVersion, this.m_sSBDHType, element, bl)) == null) {
                return ESuccess.FAILURE;
            }
            if (this.m_aMLSTo != null) {
                object.setMLSToScheme(this.m_aMLSTo.getScheme()).setMLSToValue(this.m_aMLSTo.getValue());
            }
            object.setMLSType(this.m_eMLSType);
            document = new PeppolSBDHDataWriter().setFavourSpeed(true).createStandardBusinessDocument((PeppolSBDHData)object);
            if (this.m_aSBDDocumentConsumer != null) {
                this.m_aSBDDocumentConsumer.accept((StandardBusinessDocument)document);
            }
            try {
                File file = aS4ResourceHelper.createTempFile();
                new SBDMarshaller().write((Object)document, file);
                this.payload(AS4OutgoingAttachment.builder().data(file).mimeType(this.m_aPayloadMimeType).compression((EAS4CompressionMode)(this.m_bCompressPayload ? EAS4CompressionMode.GZIP : null)).contentID(this.m_sPayloadContentID));
            }
            catch (IOException iOException) {
                throw new Phase4PeppolException("Failed to create temporary file for SBDH", iOException);
            }
            return ESuccess.SUCCESS;
        }

        private static /* synthetic */ boolean lambda$finishFields$0(Scope scope) {
            return "COUNTRY_C1".equals(scope.getType());
        }
    }

    @NotThreadSafe
    public static class PeppolUserMessageSBDHBuilder
    extends AbstractPeppolUserMessageBuilder<PeppolUserMessageSBDHBuilder> {
        private byte[] m_aPayloadBytes;

        @Nonnull
        public PeppolUserMessageSBDHBuilder payload(@Nonnull byte[] byArray) {
            ValueEnforcer.notNull((Object)byArray, (String)"SBDHBytes");
            this.m_aPayloadBytes = byArray;
            return this;
        }

        @Nonnull
        public PeppolUserMessageSBDHBuilder payloadAndMetadata(@Nonnull PeppolSBDHData peppolSBDHData) {
            ValueEnforcer.notNull((Object)peppolSBDHData, (String)"SBDH");
            if (!peppolSBDHData.areAllFieldsSet(true)) {
                throw new IllegalArgumentException("The provided Peppol SBDH data is incomplete. See logs for details.");
            }
            StandardBusinessDocument standardBusinessDocument = new PeppolSBDHDataWriter().createStandardBusinessDocument(peppolSBDHData);
            return ((PeppolUserMessageSBDHBuilder)((Object)((PeppolUserMessageSBDHBuilder)((Object)((PeppolUserMessageSBDHBuilder)((Object)((PeppolUserMessageSBDHBuilder)((Object)((PeppolUserMessageSBDHBuilder)((Object)this.senderParticipantID(peppolSBDHData.getSenderAsIdentifier()))).receiverParticipantID(peppolSBDHData.getReceiverAsIdentifier()))).documentTypeID(peppolSBDHData.getDocumentTypeAsIdentifier()))).processID(peppolSBDHData.getProcessAsIdentifier()))).countryC1(peppolSBDHData.getCountryC1()))).payload(new SBDMarshaller().getAsBytes((Object)standardBusinessDocument));
        }

        @Override
        @OverridingMethodsMustInvokeSuper
        public boolean isEveryRequiredFieldSet() {
            if (!super.isEveryRequiredFieldSet()) {
                return false;
            }
            if (this.m_aPayloadBytes == null) {
                LOGGER.warn("The field 'payloadBytes' is not set");
                return false;
            }
            return true;
        }

        @Override
        @OverridingMethodsMustInvokeSuper
        protected ESuccess finishFields(@Nonnull AS4ResourceHelper aS4ResourceHelper) throws Phase4Exception {
            if (super.finishFields(aS4ResourceHelper).isFailure()) {
                return ESuccess.FAILURE;
            }
            this.payload(AS4OutgoingAttachment.builder().data(this.m_aPayloadBytes).mimeType(this.m_aPayloadMimeType).compression((EAS4CompressionMode)(this.m_bCompressPayload ? EAS4CompressionMode.GZIP : null)));
            return ESuccess.SUCCESS;
        }
    }

    @NotThreadSafe
    public static abstract class AbstractPeppolUserMessageBuilder<IMPLTYPE extends AbstractPeppolUserMessageBuilder<IMPLTYPE>>
    extends AbstractAS4UserMessageBuilderMIMEPayload<IMPLTYPE> {
        public static final boolean DEFAULT_COMPRESS_PAYLOAD = true;
        public static final boolean DEFAULT_CHECK_RECEIVER_AP_CERTIFICATE = true;
        protected IParticipantIdentifier m_aSenderID;
        protected IParticipantIdentifier m_aReceiverID;
        protected IDocumentTypeIdentifier m_aDocTypeID;
        protected IProcessIdentifier m_aProcessID;
        protected String m_sCountryC1;
        protected IMimeType m_aPayloadMimeType;
        protected boolean m_bCompressPayload;
        protected String m_sPayloadContentID;
        protected IAS4EndpointDetailProvider m_aEndpointDetailProvider;
        private IPhase4PeppolCertificateCheckResultHandler m_aCertificateConsumer;
        private Consumer<String> m_aAPEndpointURLConsumer;
        private Consumer<String> m_aAPTechnicalContactConsumer;
        private boolean m_bCheckReceiverAPCertificate;
        protected TrustedCAChecker m_aCAChecker;
        private OffsetDateTime m_aEffectiveSendingDT;

        public AbstractPeppolUserMessageBuilder() {
            try {
                this.as4ProfileID("peppol");
                this.httpClientFactory((HttpClientSettings)new Phase4PeppolHttpClientSettings());
                this.agreementRef("urn:fdc:peppol.eu:2017:agreements:tia:ap_provider");
                this.fromPartyIDType("urn:fdc:peppol.eu:2017:identifiers:ap");
                this.fromRole("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/initiator");
                this.toPartyIDType("urn:fdc:peppol.eu:2017:identifiers:ap");
                this.toRole("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/responder");
                this.payloadMimeType(CMimeType.APPLICATION_XML);
                this.compressPayload(true);
                this.checkReceiverAPCertificate(true);
                this.peppolAP_CAChecker(PeppolTrustedCA.peppolAllAP());
                this.signingParams().setSubjectCertConstraints(new Pattern[]{PeppolPMode.CERTIFICATE_SUBJECT_CONSTRAINT_PATTERN});
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to init AS4 Client builder", exception);
            }
        }

        @Nonnull
        public final IMPLTYPE senderParticipantID(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
            ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"SenderID");
            if (this.m_aSenderID != null) {
                LOGGER.warn("An existing SenderParticipantID is overridden");
            }
            this.m_aSenderID = iParticipantIdentifier;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE receiverParticipantID(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
            ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ReceiverID");
            if (this.m_aReceiverID != null) {
                LOGGER.warn("An existing ReceiverParticipantID is overridden");
            }
            this.m_aReceiverID = iParticipantIdentifier;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nullable
        public final IDocumentTypeIdentifier documentTypeID() {
            return this.m_aDocTypeID;
        }

        @Nonnull
        public final IMPLTYPE documentTypeID(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
            ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
            if (this.m_aDocTypeID != null) {
                LOGGER.warn("An existing DocumentTypeID is overridden");
            }
            this.m_aDocTypeID = iDocumentTypeIdentifier;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.action(iDocumentTypeIdentifier.getURIEncoded())));
        }

        @Nullable
        public final IProcessIdentifier processID() {
            return this.m_aProcessID;
        }

        @Nonnull
        public final IMPLTYPE processID(@Nonnull IProcessIdentifier iProcessIdentifier) {
            ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
            if (this.m_aProcessID != null) {
                LOGGER.warn("An existing ProcessID is overridden");
            }
            this.m_aProcessID = iProcessIdentifier;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.service(iProcessIdentifier.getScheme(), iProcessIdentifier.getValue())));
        }

        @Nonnull
        public final IMPLTYPE countryC1(@Nullable String string) {
            this.m_sCountryC1 = string;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE senderPartyID(@Nonnull @Nonempty String string) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"SenderPartyID");
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.fromPartyID(string)));
        }

        @Nonnull
        public final IMPLTYPE payloadMimeType(@Nonnull IMimeType iMimeType) {
            ValueEnforcer.notNull((Object)iMimeType, (String)"PayloadMimeType");
            this.m_aPayloadMimeType = iMimeType;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE compressPayload(boolean bl) {
            this.m_bCompressPayload = bl;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE payloadContentID(@Nullable String string) {
            this.m_sPayloadContentID = string;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE endpointDetailProvider(@Nonnull IAS4EndpointDetailProvider iAS4EndpointDetailProvider) {
            ValueEnforcer.notNull((Object)iAS4EndpointDetailProvider, (String)"EndpointDetailProvider");
            if (this.m_aEndpointDetailProvider != null) {
                LOGGER.warn("An existing EndpointDetailProvider is overridden");
            }
            this.m_aEndpointDetailProvider = iAS4EndpointDetailProvider;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE smpClient(@Nonnull SMPClientReadOnly sMPClientReadOnly) {
            return this.endpointDetailProvider((IAS4EndpointDetailProvider)AS4EndpointDetailProviderPeppol.create((SMPClientReadOnly)sMPClientReadOnly));
        }

        @Nonnull
        public final IMPLTYPE receiverEndpointDetails(@Nonnull EndpointType endpointType) throws CertificateException {
            return this.receiverEndpointDetails(SMPClientReadOnly.getEndpointCertificate((EndpointType)endpointType), SMPClientReadOnly.getEndpointAddress((EndpointType)endpointType));
        }

        @Nonnull
        public final IMPLTYPE receiverEndpointDetails(@Nonnull X509Certificate x509Certificate, @Nonnull @Nonempty String string) {
            return this.endpointDetailProvider((IAS4EndpointDetailProvider)new AS4EndpointDetailProviderConstant(x509Certificate, string));
        }

        @Nonnull
        public final IMPLTYPE certificateConsumer(@Nullable IPhase4PeppolCertificateCheckResultHandler iPhase4PeppolCertificateCheckResultHandler) {
            this.m_aCertificateConsumer = iPhase4PeppolCertificateCheckResultHandler;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE endpointURLConsumer(@Nullable Consumer<String> consumer) {
            this.m_aAPEndpointURLConsumer = consumer;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE technicalContactConsumer(@Nullable Consumer<String> consumer) {
            this.m_aAPTechnicalContactConsumer = consumer;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE checkReceiverAPCertificate(boolean bl) {
            this.m_bCheckReceiverAPCertificate = bl;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nonnull
        public final IMPLTYPE peppolAP_CAChecker(@Nonnull TrustedCAChecker trustedCAChecker) {
            ValueEnforcer.notNull((Object)trustedCAChecker, (String)"CAChecker");
            this.m_aCAChecker = trustedCAChecker;
            return (IMPLTYPE)((Object)((AbstractPeppolUserMessageBuilder)this.thisAsT()));
        }

        @Nullable
        public final OffsetDateTime effectiveSendingDateTime() {
            return this.m_aEffectiveSendingDT;
        }

        protected final boolean isEndpointDetailProviderUsable() {
            if (this.m_aReceiverID == null) {
                LOGGER.warn("The field 'receiverID' is not set");
                return false;
            }
            if (this.m_aDocTypeID == null) {
                LOGGER.warn("The field 'docTypeID' is not set");
                return false;
            }
            if (this.m_aProcessID == null) {
                LOGGER.warn("The field 'processID' is not set");
                return false;
            }
            if (this.m_aEndpointDetailProvider == null) {
                LOGGER.warn("The field 'endpointDetailProvider' is not set");
                return false;
            }
            return true;
        }

        @OverridingMethodsMustInvokeSuper
        protected ESuccess finishFields(@Nonnull AS4ResourceHelper aS4ResourceHelper) throws Phase4Exception {
            Object object;
            if (!this.isEndpointDetailProviderUsable()) {
                LOGGER.error("At least one mandatory field for endpoint discovery is not set and therefore the AS4 message cannot be send.");
                return ESuccess.FAILURE;
            }
            this.m_aEndpointDetailProvider.init(this.m_aDocTypeID, this.m_aProcessID, this.m_aReceiverID);
            X509Certificate x509Certificate = this.m_aEndpointDetailProvider.getReceiverAPCertificate();
            if (this.m_bCheckReceiverAPCertificate) {
                Phase4PeppolSender._checkReceiverAPCert(this.m_aCAChecker, x509Certificate, this.m_aCertificateConsumer, ETriState.UNDEFINED, null);
            } else {
                LOGGER.warn("The check of the receiver's Peppol AP certificate was explicitly disabled.");
                if (this.m_aCertificateConsumer != null) {
                    object = MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
                    this.m_aCertificateConsumer.onCertificateCheckResult(x509Certificate, (OffsetDateTime)object, ECertificateCheckResult.NOT_CHECKED);
                }
            }
            this.receiverCertificate(x509Certificate);
            object = this.m_aEndpointDetailProvider.getReceiverAPEndpointURL();
            if (this.m_aAPEndpointURLConsumer != null) {
                this.m_aAPEndpointURLConsumer.accept((String)object);
            }
            this.endpointURL((String)object);
            if (this.m_aAPTechnicalContactConsumer != null) {
                this.m_aAPTechnicalContactConsumer.accept(this.m_aEndpointDetailProvider.getReceiverTechnicalContact());
            }
            this.toPartyID(CertificateHelper.getSubjectCN((X509Certificate)x509Certificate));
            return super.finishFields(aS4ResourceHelper);
        }

        @OverridingMethodsMustInvokeSuper
        public boolean isEveryRequiredFieldSet() {
            if (!super.isEveryRequiredFieldSet()) {
                return false;
            }
            if (this.m_aPayload == null) {
                LOGGER.warn("The field 'payload' is not set");
                return false;
            }
            if (this.m_aSenderID == null) {
                LOGGER.warn("The field 'senderID' is not set");
                return false;
            }
            if (this.m_aReceiverID == null) {
                LOGGER.warn("The field 'receiverID' is not set");
                return false;
            }
            if (this.m_aDocTypeID == null) {
                LOGGER.warn("The field 'docTypeID' is not set");
                return false;
            }
            if (this.m_aProcessID == null) {
                LOGGER.warn("The field 'processID' is not set");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sCountryC1)) {
                LOGGER.warn("The field 'countryC1' is not set");
                return false;
            }
            if (this.m_aEndpointDetailProvider == null) {
                LOGGER.warn("The field 'endpointDetailProvider' is not set");
                return false;
            }
            return true;
        }

        protected void customizeBeforeSending() throws Phase4Exception {
            this.addMessageProperty(MessageProperty.builder().name("originalSender").type(this.m_aSenderID.getScheme()).value(this.m_aSenderID.getValue()));
            this.addMessageProperty(MessageProperty.builder().name("finalRecipient").type(this.m_aReceiverID.getScheme()).value(this.m_aReceiverID.getValue()));
            IAS4SendingDateTimeConsumer iAS4SendingDateTimeConsumer = this.m_aSendingDTConsumer;
            this.sendingDateTimeConsumer(offsetDateTime -> {
                this.m_aEffectiveSendingDT = offsetDateTime;
                if (iAS4SendingDateTimeConsumer != null) {
                    iAS4SendingDateTimeConsumer.onEffectiveSendingDateTime(offsetDateTime);
                }
            });
        }

        @Nonnull
        public final PeppolReportingItem createPeppolReportingItemAfterSending(@Nonnull @Nonempty String string) throws Phase4Exception {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"EndUserID");
            if (this.m_aEffectiveSendingDT == null) {
                throw new Phase4PeppolException("A Peppol Reporting item can only be created AFTER sending").setRetryFeasible(false);
            }
            return PeppolReportingItem.builder().exchangeDateTime(this.m_aEffectiveSendingDT).directionSending().c2ID(this.m_sFromPartyID).c3ID(this.m_sToPartyID).docTypeID(this.m_aDocTypeID).processID(this.m_aProcessID).transportProtocolPeppolAS4v2().c1CountryCode(this.m_sCountryC1).c4CountryCode(null).endUserID(string).build();
        }

        public final void createAndStorePeppolReportingItemAfterSending(@Nonnull @Nonempty String string) throws Phase4Exception {
            if (PeppolReportingBackend.getBackendService() == null) {
                throw new Phase4PeppolException("No Peppol Reporting Backend is available. Cannot store Reporting Items").setRetryFeasible(false);
            }
            if (PeppolReportingHelper.isDocumentTypeEligableForReporting((IDocumentTypeIdentifier)this.m_aDocTypeID)) {
                try {
                    LOGGER.info("Creating Peppol Reporting Item and storing it");
                    PeppolReportingItem peppolReportingItem = this.createPeppolReportingItemAfterSending(string);
                    PeppolReportingBackend.withBackendDo((IConfig)AS4Configuration.getConfig(), iPeppolReportingBackendSPI -> iPeppolReportingBackendSPI.storeReportingItem(peppolReportingItem));
                }
                catch (PeppolReportingBackendException peppolReportingBackendException) {
                    throw new Phase4PeppolException("Failed to store Peppol Reporting Item", peppolReportingBackendException);
                }
            } else {
                LOGGER.info("The Document Type ID is not eligible for Peppol Reporting: '" + this.m_aDocTypeID.getURIEncoded() + "'");
            }
        }
    }
}

