/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.peppol.IPhase4PeppolValidationResultHandler;
import com.helger.phase4.util.Phase4Exception;
import com.helger.phive.api.execute.ValidationExecutionManager;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSetRegistry;
import com.helger.phive.api.result.ValidationResultList;
import com.helger.phive.api.source.IValidationSource;
import com.helger.phive.api.validity.IValidityDeterminator;
import com.helger.phive.en16931.EN16931Validation;
import com.helger.phive.peppol.PeppolValidation;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.source.ValidationSourceXML;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Phase4PeppolValidation {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(Phase4PeppolValidation.class);
    private static final IValidationExecutorSetRegistry<IValidationSourceXML> VES_REGISTRY = Phase4PeppolValidation.createDefaultRegistry();

    private Phase4PeppolValidation() {
    }

    @Nonnull
    @ReturnsMutableObject
    public static IValidationExecutorSetRegistry<IValidationSourceXML> getDefaultRegistry() {
        return VES_REGISTRY;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ValidationExecutorSetRegistry<IValidationSourceXML> createDefaultRegistry() {
        ValidationExecutorSetRegistry validationExecutorSetRegistry = new ValidationExecutorSetRegistry();
        EN16931Validation.initEN16931((IValidationExecutorSetRegistry)validationExecutorSetRegistry);
        PeppolValidation.initStandard((IValidationExecutorSetRegistry)validationExecutorSetRegistry);
        return validationExecutorSetRegistry;
    }

    public static void validateOutgoingBusinessDocument(@Nonnull Element element, @Nonnull DVRCoordinate dVRCoordinate, @Nonnull IPhase4PeppolValidationResultHandler iPhase4PeppolValidationResultHandler) throws Phase4Exception {
        Phase4PeppolValidation.validateOutgoingBusinessDocument(element, VES_REGISTRY, dVRCoordinate, iPhase4PeppolValidationResultHandler);
    }

    public static void validateOutgoingBusinessDocument(@Nonnull Element element, @Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry, @Nonnull DVRCoordinate dVRCoordinate, @Nonnull IPhase4PeppolValidationResultHandler iPhase4PeppolValidationResultHandler) throws Phase4Exception {
        ValueEnforcer.notNull((Object)element, (String)"XMLElement");
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"VESRegistry");
        ValueEnforcer.notNull((Object)dVRCoordinate, (String)"VESID");
        ValueEnforcer.notNull((Object)iPhase4PeppolValidationResultHandler, (String)"ValidationResultHandler");
        IValidationExecutorSet iValidationExecutorSet = iValidationExecutorSetRegistry.getOfID(dVRCoordinate);
        if (iValidationExecutorSet == null) {
            throw new Phase4Exception("The validation executor set ID " + dVRCoordinate.getAsSingleID() + " is unknown!").setRetryFeasible(false);
        }
        ValidationResultList validationResultList = ValidationExecutionManager.executeValidation((IValidityDeterminator)IValidityDeterminator.createDefault(), (IValidationExecutorSet)iValidationExecutorSet, (IValidationSource)ValidationSourceXML.create(null, (Node)element));
        if (validationResultList.containsAtLeastOneError()) {
            iPhase4PeppolValidationResultHandler.onValidationErrors(validationResultList);
            LOGGER.warn("Continue to send AS4 message, although validation errors are contained!");
        } else {
            iPhase4PeppolValidationResultHandler.onValidationSuccess(validationResultList);
        }
    }
}

