/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html;

import com.helger.html.CHTMLDocTypes;
import com.helger.xml.microdom.IMicroDocumentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHTMLVersion {
    XHTML10_STRICT(false){

        @Override
        @Nonnull
        public IMicroDocumentType getDocType() {
            return CHTMLDocTypes.DOCTYPE_XHTML10_STRICT;
        }

        @Override
        @Nonnull
        public String getNamespaceURI() {
            return "http://www.w3.org/1999/xhtml";
        }
    }
    ,
    XHTML10_TRANSITIONAL(false){

        @Override
        @Nonnull
        public IMicroDocumentType getDocType() {
            return CHTMLDocTypes.DOCTYPE_XHTML10_TRANS;
        }

        @Override
        @Nonnull
        public String getNamespaceURI() {
            return "http://www.w3.org/1999/xhtml";
        }
    }
    ,
    XHTML11(false){

        @Override
        @Nonnull
        public IMicroDocumentType getDocType() {
            return CHTMLDocTypes.DOCTYPE_XHTML11;
        }

        @Override
        @Nonnull
        public String getNamespaceURI() {
            return "http://www.w3.org/1999/xhtml";
        }
    }
    ,
    HTML5(true){

        @Override
        @Nonnull
        public IMicroDocumentType getDocType() {
            return CHTMLDocTypes.DOCTYPE_HTML5;
        }

        @Override
        @Nullable
        public String getNamespaceURI() {
            return null;
        }
    }
    ,
    HTML51(true){

        @Override
        @Nonnull
        public IMicroDocumentType getDocType() {
            return CHTMLDocTypes.DOCTYPE_HTML5;
        }

        @Override
        @Nullable
        public String getNamespaceURI() {
            return null;
        }
    };

    private final boolean m_bIsAtLeastHTML5;

    private EHTMLVersion(boolean bl) {
        this.m_bIsAtLeastHTML5 = bl;
    }

    @Nonnull
    public abstract IMicroDocumentType getDocType();

    @Nullable
    public abstract String getNamespaceURI();

    public boolean isXHTML10() {
        return this == XHTML10_STRICT || this == XHTML10_TRANSITIONAL;
    }

    public boolean isXHTML11() {
        return this == XHTML11;
    }

    public boolean isPriorToHTML5() {
        return !this.m_bIsAtLeastHTML5;
    }

    public boolean isAtLeastHTML5() {
        return this.m_bIsAtLeastHTML5;
    }
}

