/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.writer.CSSWriterSettings;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.IHCCustomizer;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSWriterSettings;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class HCConversionSettings
implements IHCConversionSettings {
    public static final boolean DEFAULT_INDENT_AND_ALIGN_HTML = true;
    public static final ECSSVersion DEFAULT_CSS_VERSION = ECSSVersion.CSS30;
    public static final boolean DEFAULT_INDENT_AND_ALIGN_CSS = true;
    public static final boolean DEFAULT_INDENT_AND_ALIGN_JS = true;
    public static final boolean DEFAULT_CONSISTENCY_CHECKS = true;
    public static final boolean DEFAULT_EXTRACT_OUT_OF_BAND_NODES = true;
    private EHTMLVersion m_eHTMLVersion;
    private String m_sHTMLNamespaceURI;
    private XMLWriterSettings m_aXMLWriterSettings;
    private CSSWriterSettings m_aCSSWriterSettings;
    private JSWriterSettings m_aJSWriterSettings;
    private boolean m_bConsistencyChecksEnabled;
    private boolean m_bExtractOutOfBandNodes;
    private IHCCustomizer m_aCustomizer;
    private String m_sNonceScript;
    private String m_sNonceStyle;

    @Nonnull
    public static XMLWriterSettings createDefaultXMLWriterSettings(@Nonnull EHTMLVersion eHTMLVersion) {
        XMLWriterSettings xMLWriterSettings = eHTMLVersion.isAtLeastHTML5() ? XMLWriterSettings.createForHTML5() : XMLWriterSettings.createForXHTML();
        return xMLWriterSettings.setIncorrectCharacterHandling(EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING).setIndent(EXMLSerializeIndent.INDENT_AND_ALIGN);
    }

    @Nonnull
    public static CSSWriterSettings createDefaultCSSWriterSettings() {
        return new CSSWriterSettings(DEFAULT_CSS_VERSION).setOptimizedOutput(false);
    }

    @Nonnull
    public static JSWriterSettings createDefaultJSWriterSettings() {
        return new JSWriterSettings().setIndentAndAlign(true);
    }

    @Nullable
    public static IHCCustomizer createDefaultCustomizer() {
        return null;
    }

    public static boolean isDefaultCustomizer(@Nullable IHCCustomizer iHCCustomizer) {
        return iHCCustomizer == null;
    }

    public HCConversionSettings(@Nonnull EHTMLVersion eHTMLVersion) {
        this.setHTMLVersion(eHTMLVersion);
        this.setToDefault();
    }

    public HCConversionSettings(@Nonnull IHCConversionSettings iHCConversionSettings) {
        this(iHCConversionSettings, iHCConversionSettings.getHTMLVersion());
    }

    public HCConversionSettings(@Nonnull IHCConversionSettings iHCConversionSettings, @Nonnull EHTMLVersion eHTMLVersion) {
        ValueEnforcer.notNull((Object)iHCConversionSettings, (String)"Base");
        ValueEnforcer.notNull((Object)((Object)eHTMLVersion), (String)"HTMLVersion");
        this.setHTMLVersion(eHTMLVersion);
        this.m_aXMLWriterSettings = iHCConversionSettings.getMutableXMLWriterSettings().getClone();
        this.m_aCSSWriterSettings = iHCConversionSettings.getMutableCSSWriterSettings().getClone();
        this.m_aJSWriterSettings = iHCConversionSettings.getMutableJSWriterSettings().getClone();
        this.m_bConsistencyChecksEnabled = iHCConversionSettings.areConsistencyChecksEnabled();
        this.m_bExtractOutOfBandNodes = iHCConversionSettings.isExtractOutOfBandNodes();
        this.m_aCustomizer = iHCConversionSettings.getCustomizer();
        this.m_sNonceScript = iHCConversionSettings.getNonceScript();
        this.m_sNonceStyle = iHCConversionSettings.getNonceStyle();
    }

    @Nonnull
    public HCConversionSettings setHTMLVersion(@Nonnull EHTMLVersion eHTMLVersion) {
        ValueEnforcer.notNull((Object)((Object)eHTMLVersion), (String)"HTMLVersion");
        this.m_eHTMLVersion = eHTMLVersion;
        this.m_sHTMLNamespaceURI = eHTMLVersion.getNamespaceURI();
        return this;
    }

    @Override
    @Nonnull
    public EHTMLVersion getHTMLVersion() {
        return this.m_eHTMLVersion;
    }

    @Override
    @Nullable
    public String getHTMLNamespaceURI() {
        return this.m_sHTMLNamespaceURI;
    }

    @Nonnull
    public HCConversionSettings setXMLWriterSettingsOptimized(boolean bl) {
        this.m_aXMLWriterSettings.setIndent(bl ? EXMLSerializeIndent.NONE : EXMLSerializeIndent.INDENT_AND_ALIGN);
        this.m_aXMLWriterSettings.setIncorrectCharacterHandling(bl ? EXMLIncorrectCharacterHandling.WRITE_TO_FILE_NO_LOG : EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING);
        return this;
    }

    @Nonnull
    public HCConversionSettings setXMLWriterSettings(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"XMLWriterSettings");
        this.m_aXMLWriterSettings = new XMLWriterSettings(iXMLWriterSettings);
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(value="Design")
    public XMLWriterSettings getXMLWriterSettings() {
        return this.m_aXMLWriterSettings;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public XMLWriterSettings getMutableXMLWriterSettings() {
        return this.m_aXMLWriterSettings.getClone();
    }

    @Nonnull
    public HCConversionSettings setCSSWriterSettingsOptimized(boolean bl) {
        this.m_aCSSWriterSettings.setOptimizedOutput(bl).setRemoveUnnecessaryCode(bl);
        return this;
    }

    @Nonnull
    public HCConversionSettings setCSSWriterSettings(@Nonnull ICSSWriterSettings iCSSWriterSettings) {
        ValueEnforcer.notNull((Object)iCSSWriterSettings, (String)"CSSWriterSettings");
        this.m_aCSSWriterSettings = new CSSWriterSettings(iCSSWriterSettings);
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(value="Design")
    public CSSWriterSettings getCSSWriterSettings() {
        return this.m_aCSSWriterSettings;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CSSWriterSettings getMutableCSSWriterSettings() {
        return new CSSWriterSettings((ICSSWriterSettings)this.m_aCSSWriterSettings);
    }

    @Nonnull
    public HCConversionSettings setJSWriterSettingsOptimized(boolean bl) {
        this.m_aJSWriterSettings.setMinimumCodeSize(bl);
        return this;
    }

    @Nonnull
    public HCConversionSettings setJSWriterSettings(@Nonnull IJSWriterSettings iJSWriterSettings) {
        ValueEnforcer.notNull((Object)iJSWriterSettings, (String)"JSWriterSettings");
        this.m_aJSWriterSettings = new JSWriterSettings(iJSWriterSettings);
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject(value="Design")
    public JSWriterSettings getJSWriterSettings() {
        return this.m_aJSWriterSettings;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public JSWriterSettings getMutableJSWriterSettings() {
        return this.m_aJSWriterSettings.getClone();
    }

    @Override
    public boolean areConsistencyChecksEnabled() {
        return this.m_bConsistencyChecksEnabled;
    }

    @Nonnull
    public HCConversionSettings setConsistencyChecksEnabled(boolean bl) {
        this.m_bConsistencyChecksEnabled = bl;
        return this;
    }

    @Override
    public boolean isExtractOutOfBandNodes() {
        return this.m_bExtractOutOfBandNodes;
    }

    @Nonnull
    public HCConversionSettings setExtractOutOfBandNodes(boolean bl) {
        this.m_bExtractOutOfBandNodes = bl;
        return this;
    }

    @Override
    @Nullable
    public IHCCustomizer getCustomizer() {
        return this.m_aCustomizer;
    }

    @Nonnull
    public HCConversionSettings setCustomizer(@Nullable IHCCustomizer iHCCustomizer) {
        this.m_aCustomizer = iHCCustomizer;
        return this;
    }

    @Override
    @Nullable
    public String getNonceScript() {
        return this.m_sNonceScript;
    }

    @Nonnull
    public HCConversionSettings setNonceScript(@Nullable String string) {
        this.m_sNonceScript = string;
        return this;
    }

    @Override
    @Nullable
    public String getNonceStyle() {
        return this.m_sNonceStyle;
    }

    @Nonnull
    public HCConversionSettings setNonceStyle(@Nullable String string) {
        this.m_sNonceStyle = string;
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    @Nonnull
    public HCConversionSettings setToDefault() {
        this.m_aXMLWriterSettings = HCConversionSettings.createDefaultXMLWriterSettings(this.m_eHTMLVersion);
        this.m_aCSSWriterSettings = HCConversionSettings.createDefaultCSSWriterSettings();
        this.m_aJSWriterSettings = HCConversionSettings.createDefaultJSWriterSettings();
        this.m_bConsistencyChecksEnabled = true;
        this.m_bExtractOutOfBandNodes = true;
        this.m_aCustomizer = HCConversionSettings.createDefaultCustomizer();
        this.m_sNonceScript = null;
        this.m_sNonceStyle = null;
        return this;
    }

    @OverridingMethodsMustInvokeSuper
    public HCConversionSettings setToOptimized() {
        this.setXMLWriterSettingsOptimized(true);
        this.setCSSWriterSettingsOptimized(true);
        this.setJSWriterSettingsOptimized(true);
        this.m_bConsistencyChecksEnabled = false;
        return this;
    }

    @Nonnull
    public HCConversionSettings getClone() {
        return new HCConversionSettings(this);
    }

    @Override
    @Nonnull
    public HCConversionSettings getClone(@Nonnull EHTMLVersion eHTMLVersion) {
        return new HCConversionSettings(this, eHTMLVersion);
    }

    @Override
    @Nonnull
    public HCConversionSettings getCloneIfNecessary(@Nonnull EHTMLVersion eHTMLVersion) {
        return this.m_eHTMLVersion.equals((Object)eHTMLVersion) ? this : this.getClone(eHTMLVersion);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("HTMLVersion", (Enum)this.m_eHTMLVersion).append("XMLWriterSettings", (Object)this.m_aXMLWriterSettings).append("CSSWriterSettings", (Object)this.m_aCSSWriterSettings).append("JSWriterSettings", (Object)this.m_aJSWriterSettings).append("ConsistencyChecksEnabled", this.m_bConsistencyChecksEnabled).append("ExtractOutOfBandNodes", this.m_bExtractOutOfBandNodes).appendIfNotNull("Customizer", (Object)this.m_aCustomizer).appendIfNotNull("NonceScript", (Object)this.m_sNonceScript).appendIfNotNull("NonceStyle", (Object)this.m_sNonceStyle).getToString();
    }
}

