/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.ext;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.html.IHCHasCSSClasses;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCHasCSSClasses
implements IHCHasCSSClasses<HCHasCSSClasses> {
    private ICommonsOrderedSet<ICSSClassProvider> m_aCSSClassProviders;

    @Override
    public boolean containsClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        return iCSSClassProvider != null && this.m_aCSSClassProviders != null && this.m_aCSSClassProviders.contains((Object)iCSSClassProvider);
    }

    @Override
    @Nonnull
    public HCHasCSSClasses addClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        if (iCSSClassProvider != null) {
            if (this.m_aCSSClassProviders == null) {
                this.m_aCSSClassProviders = new CommonsLinkedHashSet();
            }
            this.m_aCSSClassProviders.add((Object)iCSSClassProvider);
        }
        return this;
    }

    @Override
    @Nonnull
    public HCHasCSSClasses removeClass(@Nullable ICSSClassProvider iCSSClassProvider) {
        if (this.m_aCSSClassProviders != null && iCSSClassProvider != null) {
            this.m_aCSSClassProviders.remove((Object)iCSSClassProvider);
        }
        return this;
    }

    @Override
    @Nonnull
    public HCHasCSSClasses removeAllClasses() {
        if (this.m_aCSSClassProviders != null) {
            this.m_aCSSClassProviders.clear();
        }
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ICSSClassProvider> getAllClasses() {
        return this.m_aCSSClassProviders.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllClassNames() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        if (this.m_aCSSClassProviders != null) {
            for (ICSSClassProvider iCSSClassProvider : this.m_aCSSClassProviders) {
                String string = iCSSClassProvider.getCSSClass();
                if (!StringHelper.hasText((String)string)) continue;
                commonsLinkedHashSet.add((Object)string);
            }
        }
        return commonsLinkedHashSet;
    }

    @Override
    @Nullable
    public String getAllClassesAsString() {
        if (this.m_aCSSClassProviders == null || this.m_aCSSClassProviders.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSClassProvider iCSSClassProvider : this.m_aCSSClassProviders) {
            String string = iCSSClassProvider.getCSSClass();
            if (!StringHelper.hasText((String)string)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean hasAnyClass() {
        return this.m_aCSSClassProviders != null && this.m_aCSSClassProviders.isNotEmpty();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIf("CSSClassProviders", this.m_aCSSClassProviders, CollectionHelper::isNotEmpty).getToString();
    }
}

