/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.html.IHCHasHTMLAttributeValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHCInputMode implements IHCHasHTMLAttributeValue
{
    NONE("none"),
    TEXT("text"),
    DECIMAL("decimal"),
    NUMERIC("numeric"),
    TEL("tel"),
    SEARCH("search"),
    EMAIL("email"),
    URL("url");

    public static final EHCInputMode DEFAULT;
    private final String m_sAttrValue;

    private EHCInputMode(String string2) {
        this.m_sAttrValue = string2;
    }

    @Nonnull
    @Nonempty
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Nullable
    public static EHCInputMode getFromAttrValueOrNull(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (EHCInputMode)EnumHelper.findFirst(EHCInputMode.class, eHCInputMode -> eHCInputMode.getAttrValue().equals(string));
    }

    static {
        DEFAULT = TEXT;
    }
}

