/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.html.CHTMLAttributes;
import com.helger.html.hc.html.IHCElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IHCAttrContainer
extends IAttributeContainer<IMicroQName, String> {
    @Nonnull
    default public EChange putIn(@Nonnull String string, @Nullable String string2) {
        return this.putIn(new MicroQName(string), string2);
    }

    default public boolean hasDataAttrs() {
        return CollectionHelper.containsAny((Iterable)this.keySet(), iMicroQName -> CHTMLAttributes.isDataAttrName(iMicroQName.getName()));
    }

    default public boolean containsDataAttr(@Nullable String string) {
        return this.containsKey(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nullable
    default public String getDataAttrValue(@Nullable String string) {
        return (String)this.getValue(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedMap<IMicroQName, String> getAllDataAttrs() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (Map.Entry entry : this.entrySet()) {
            if (!CHTMLAttributes.isDataAttrName(((IMicroQName)entry.getKey()).getName())) continue;
            commonsLinkedHashMap.put((Object)((IMicroQName)entry.getKey()), (Object)((String)entry.getValue()));
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, int n) {
        return this.setDataAttr(string, Integer.toString(n));
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, long l) {
        return this.setDataAttr(string, Long.toString(l));
    }

    @Nonnull
    default public EChange setDataAttr(@Nullable String string, @Nullable String string2) {
        return this.putIn(CHTMLAttributes.makeDataAttrName(string), string2);
    }

    @Nonnull
    default public EChange removeDataAttr(@Nullable String string) {
        return this.removeObject(CHTMLAttributes.makeDataAttrName(string));
    }

    @Nonnull
    default public EChange setAriaControls(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_CONTROLS, string);
    }

    default public boolean containsAriaDescription() {
        return this.containsKey(CHTMLAttributes.ARIA_DESCRIPTION);
    }

    @Nonnull
    default public EChange setAriaDescription(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_DESCRIPTION, string);
    }

    default public boolean containsAriaDescribedBy() {
        return this.containsKey(CHTMLAttributes.ARIA_DESCRIBEDBY);
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_DESCRIBEDBY, string);
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull String string) {
        String string2 = (String)this.getValue(CHTMLAttributes.ARIA_DESCRIBEDBY);
        boolean bl = StringHelper.hasText((String)string2) && !string2.contains(string);
        return this.setAriaDescribedBy((String)(bl ? string2 + " " + string : string));
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull IHCElement<?> iHCElement) {
        return this.setAriaDescribedBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull IHCElement<?> iHCElement) {
        return this.addToAriaDescribedBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange setAriaDescribedBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        return this.setAriaDescribedBy(StringHelper.imploder().source(iterable, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        EChange eChange = EChange.UNCHANGED;
        for (IHCElement<?> iHCElement : iterable) {
            eChange = eChange.or((IChangeIndicator)this.addToAriaDescribedBy(iHCElement));
        }
        return eChange;
    }

    @Nonnull
    default public EChange setAriaDescribedBy(IHCElement<?> ... iHCElementArray) {
        return this.setAriaDescribedBy(StringHelper.imploder().source((Object[])iHCElementArray, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    default public EChange addToAriaDescribedBy(IHCElement<?> ... iHCElementArray) {
        EChange eChange = EChange.UNCHANGED;
        for (IHCElement<?> iHCElement : iHCElementArray) {
            eChange = eChange.or((IChangeIndicator)this.addToAriaDescribedBy(iHCElement));
        }
        return eChange;
    }

    @Nonnull
    default public EChange setAriaExpanded(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_EXPANDED, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaHasPopup(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_HASPOPUP, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaHidden(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_HIDDEN, Boolean.toString(bl));
    }

    @Nonnull
    default public EChange setAriaInvalid(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_INVALID, Boolean.toString(bl));
    }

    default public boolean containsAriaLabel() {
        return this.containsKey(CHTMLAttributes.ARIA_LABEL);
    }

    @Nonnull
    default public EChange setAriaLabel(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_LABEL, string);
    }

    default public boolean containsAriaLabeledBy() {
        return this.containsKey(CHTMLAttributes.ARIA_LABELLEDBY);
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull String string) {
        return this.putIn(CHTMLAttributes.ARIA_LABELLEDBY, string);
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="9.2.7")
    default public EChange addAriaLabeledBy(@Nonnull String string) {
        return this.addToAriaLabeledBy(string);
    }

    @Nonnull
    default public EChange addToAriaLabeledBy(@Nonnull String string) {
        String string2 = (String)this.getValue(CHTMLAttributes.ARIA_LABELLEDBY);
        boolean bl = StringHelper.hasText((String)string2) && !string2.contains(string);
        return this.setAriaLabeledBy((String)(bl ? string2 + " " + string : string));
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull IHCElement<?> iHCElement) {
        return this.setAriaLabeledBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="9.2.7")
    default public EChange addAriaLabeledBy(@Nonnull IHCElement<?> iHCElement) {
        return this.addToAriaLabeledBy(iHCElement);
    }

    @Nonnull
    default public EChange addToAriaLabeledBy(@Nonnull IHCElement<?> iHCElement) {
        return this.addToAriaLabeledBy(((IHCElement)iHCElement.ensureID()).getID());
    }

    @Nonnull
    default public EChange setAriaLabeledBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        return this.setAriaLabeledBy(StringHelper.imploder().source(iterable, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="9.2.7")
    default public EChange addAriaLabeledBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        return this.addToAriaLabeledBy(iterable);
    }

    @Nonnull
    default public EChange addToAriaLabeledBy(@Nonnull Iterable<? extends IHCElement<?>> iterable) {
        EChange eChange = EChange.UNCHANGED;
        for (IHCElement<?> iHCElement : iterable) {
            eChange = eChange.or((IChangeIndicator)this.addToAriaLabeledBy(iHCElement));
        }
        return eChange;
    }

    @Nonnull
    default public EChange setAriaLabeledBy(IHCElement<?> ... iHCElementArray) {
        return this.setAriaLabeledBy(StringHelper.imploder().source((Object[])iHCElementArray, iHCElement -> ((IHCElement)iHCElement.ensureID()).getID()).separator(' ').build());
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="9.2.7")
    default public EChange addAriaLabeledBy(IHCElement<?> ... iHCElementArray) {
        return this.addToAriaLabeledBy(iHCElementArray);
    }

    @Nonnull
    default public EChange addToAriaLabeledBy(IHCElement<?> ... iHCElementArray) {
        EChange eChange = EChange.UNCHANGED;
        for (IHCElement<?> iHCElement : iHCElementArray) {
            eChange = eChange.or((IChangeIndicator)this.addToAriaLabeledBy(iHCElement));
        }
        return eChange;
    }

    @Nonnull
    default public EChange setAriaRequired(boolean bl) {
        return this.putIn(CHTMLAttributes.ARIA_REQUIRED, Boolean.toString(bl));
    }
}

