/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.embedded;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.dimension.SizeInt;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCMediaElementChild;
import com.helger.html.hc.html.embedded.EHCCORSSettings;
import com.helger.html.hc.html.embedded.EHCLoadingType;
import com.helger.html.hc.html.embedded.IHCImg;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHCImg<IMPLTYPE extends AbstractHCImg<IMPLTYPE>>
extends AbstractHCMediaElementChild<IMPLTYPE>
implements IHCImg<IMPLTYPE> {
    private ISimpleURL m_aSrc;
    private String m_sSrcSet;
    private String m_sSizes;
    private SizeInt m_aExtent;
    private String m_sAlt;
    private EHCCORSSettings m_eCrossOrigin;
    private EHCLoadingType m_eLoading;

    public AbstractHCImg() {
        super(EHTMLElement.IMG);
    }

    @Override
    @Nullable
    public final ISimpleURL getSrc() {
        return this.m_aSrc;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSrc(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"src");
        this.m_aSrc = iSimpleURL;
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getSrcSet() {
        return this.m_sSrcSet;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSrcSet(@Nullable String string) {
        this.m_sSrcSet = string;
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getSizes() {
        return this.m_sSizes;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setSizes(@Nullable String string) {
        this.m_sSizes = string;
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    public final boolean hasExtent() {
        return this.m_aExtent != null;
    }

    @Override
    public final int getWidth(int n) {
        return this.m_aExtent != null ? this.m_aExtent.getWidth() : n;
    }

    @Override
    public final int getHeight(int n) {
        return this.m_aExtent != null ? this.m_aExtent.getHeight() : n;
    }

    @Override
    @Nullable
    public final SizeInt getExtent() {
        return this.m_aExtent;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setExtent(@Nullable SizeInt sizeInt) {
        this.m_aExtent = sizeInt;
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE setExtent(@Nonnegative int n, @Nonnegative int n2) {
        return (IMPLTYPE)this.setExtent(new SizeInt(n, n2));
    }

    @Override
    @Nonnull
    public final IMPLTYPE scaleToWidth(@Nonnegative int n) {
        if (this.m_aExtent != null) {
            this.m_aExtent = this.m_aExtent.getScaledToWidth(n);
        }
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE scaleToHeight(@Nonnegative int n) {
        if (this.m_aExtent != null) {
            this.m_aExtent = this.m_aExtent.getScaledToHeight(n);
        }
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE scaleBestMatching(@Nonnegative int n, @Nonnegative int n2) {
        if (this.m_aExtent != null) {
            this.m_aExtent = this.m_aExtent.getBestMatchingSize(n, n2);
        }
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getAlt() {
        return this.m_sAlt;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setAlt(@Nullable String string) {
        this.m_sAlt = string;
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCCORSSettings getCrossOrigin() {
        return this.m_eCrossOrigin;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCrossOrigin(@Nullable EHCCORSSettings eHCCORSSettings) {
        this.m_eCrossOrigin = eHCCORSSettings;
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Nullable
    public final EHCLoadingType getLoading() {
        return this.m_eLoading;
    }

    @Nonnull
    public final IMPLTYPE setLoading(@Nullable EHCLoadingType eHCLoadingType) {
        this.m_eLoading = eHCLoadingType;
        return (IMPLTYPE)((AbstractHCImg)this.thisAsT());
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_aSrc != null) {
            iMicroElement.setAttribute(CHTMLAttributes.SRC, this.m_aSrc.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset()));
        }
        if (StringHelper.hasText((String)this.m_sSrcSet)) {
            iMicroElement.setAttribute(CHTMLAttributes.SRCSET, this.m_sSrcSet);
        }
        if (StringHelper.hasText((String)this.m_sSizes)) {
            iMicroElement.setAttribute(CHTMLAttributes.SIZES, this.m_sSizes);
        }
        if (this.m_aExtent != null) {
            iMicroElement.setAttribute(CHTMLAttributes.WIDTH, this.m_aExtent.getWidth());
            iMicroElement.setAttribute(CHTMLAttributes.HEIGHT, this.m_aExtent.getHeight());
        }
        if (StringHelper.hasText((String)this.m_sAlt)) {
            iMicroElement.setAttribute(CHTMLAttributes.ALT, this.m_sAlt);
            iMicroElement.removeAttribute(CHTMLAttributes.TITLE);
        } else {
            String string = this.getTitle();
            if (string != null) {
                iMicroElement.setAttribute(CHTMLAttributes.ALT, string);
                iMicroElement.removeAttribute(CHTMLAttributes.TITLE);
            } else {
                iMicroElement.setAttribute(CHTMLAttributes.ALT, "");
            }
        }
        if (this.m_eCrossOrigin != null) {
            iMicroElement.setAttribute(CHTMLAttributes.CROSSORIGIN, (IHasAttributeValue)this.m_eCrossOrigin);
        }
        if (this.m_eLoading != null) {
            iMicroElement.setAttribute(CHTMLAttributes.LOADING, (IHasAttributeValue)this.m_eLoading);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Src", (Object)this.m_aSrc).appendIfNotNull("SrcSet", (Object)this.m_sSrcSet).appendIfNotNull("Sizes", (Object)this.m_sSizes).appendIfNotNull("Extent", (Object)this.m_aExtent).appendIfNotNull("Alt", (Object)this.m_sAlt).appendIfNotNull("CrossOrigin", (Object)this.m_eCrossOrigin).appendIfNotNull("Loading", (Object)this.m_eLoading).getToString();
    }
}

