/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.forms;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.forms.IHCControl;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractHCControl<IMPLTYPE extends AbstractHCControl<IMPLTYPE>>
extends AbstractHCElement<IMPLTYPE>
implements IHCControl<IMPLTYPE> {
    public static final boolean DEFAULT_DISABLED = false;
    public static final boolean DEFAULT_READ_ONLY = false;
    public static final boolean DEFAULT_REQUIRED = false;
    public static final ICSSClassProvider CSS_CLASS_READ_ONLY = DefaultCSSClassProvider.create("read-only");
    private boolean m_bDisabled = false;
    private String m_sName;
    private boolean m_bReadOnly = false;
    private boolean m_bRequired = false;

    public AbstractHCControl(@Nonnull @Nonempty EHTMLElement eHTMLElement) {
        super(eHTMLElement);
    }

    @Override
    public final boolean isDisabled() {
        return this.m_bDisabled;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDisabled(boolean bl) {
        this.m_bDisabled = bl;
        return (IMPLTYPE)((AbstractHCControl)this.thisAsT());
    }

    @Override
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setName(@Nullable String string) {
        this.m_sName = string;
        return (IMPLTYPE)((AbstractHCControl)this.thisAsT());
    }

    @Override
    public final boolean isReadOnly() {
        return this.m_bReadOnly;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setReadOnly(boolean bl) {
        this.m_bReadOnly = bl;
        return (IMPLTYPE)((AbstractHCControl)this.thisAsT());
    }

    @Override
    public final boolean isRequired() {
        return this.m_bRequired;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setRequired(boolean bl) {
        this.m_bRequired = bl;
        return (IMPLTYPE)((AbstractHCControl)this.thisAsT());
    }

    @Override
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        if (this.m_bReadOnly) {
            this.addClass(CSS_CLASS_READ_ONLY);
            this.setTabIndex(-1L);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_bDisabled) {
            iMicroElement.setAttribute(CHTMLAttributes.DISABLED, CHTMLAttributeValues.DISABLED);
        }
        if (StringHelper.hasText((String)this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (this.m_bReadOnly) {
            iMicroElement.setAttribute(CHTMLAttributes.READONLY, CHTMLAttributeValues.READONLY);
        }
        if (this.m_bRequired) {
            iMicroElement.setAttribute(CHTMLAttributes.REQUIRED, CHTMLAttributeValues.REQUIRED);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Disabled", this.m_bDisabled).appendIfNotNull("Name", (Object)this.m_sName).append("ReadOnly", this.m_bReadOnly).append("Required", this.m_bRequired).getToString();
    }
}

