/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.interactive;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributeValues;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.IHCHasState;
import com.helger.html.hc.html.interactive.EHCCommandType;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCCommand
extends AbstractHCElement<HCCommand>
implements IHCHasState<HCCommand> {
    public static final boolean DEFAULT_CHECKED = false;
    public static final boolean DEFAULT_DEFAULT = false;
    public static final boolean DEFAULT_DISABLED = false;
    private boolean m_bChecked = false;
    private boolean m_bDefault = false;
    private boolean m_bDisabled = false;
    private ISimpleURL m_aIcon;
    private String m_sLabel;
    private String m_sRadioGroup;
    private EHCCommandType m_eType = EHCCommandType.DEFAULT;

    public HCCommand() {
        super(EHTMLElement.COMMAND);
    }

    public final boolean isChecked() {
        return this.m_bChecked;
    }

    @Nonnull
    public final HCCommand setChecked(boolean bl) {
        this.m_bChecked = bl;
        return this;
    }

    public final boolean isDefault() {
        return this.m_bDefault;
    }

    @Nonnull
    public final HCCommand setDefault(boolean bl) {
        this.m_bDefault = bl;
        return this;
    }

    @Override
    public final boolean isDisabled() {
        return this.m_bDisabled;
    }

    @Override
    @Nonnull
    public final HCCommand setDisabled(boolean bl) {
        this.m_bDisabled = bl;
        return this;
    }

    @Nullable
    public final ISimpleURL getIcon() {
        return this.m_aIcon;
    }

    @Nonnull
    public final HCCommand setIcon(@Nullable ISimpleURL iSimpleURL) {
        this.m_aIcon = iSimpleURL;
        return this;
    }

    @Nullable
    public final String getLabel() {
        return this.m_sLabel;
    }

    @Nonnull
    public final HCCommand setLabel(@Nullable String string) {
        this.m_sLabel = string;
        return this;
    }

    @Nullable
    public final String getRadioGroup() {
        return this.m_sRadioGroup;
    }

    @Nonnull
    public final HCCommand setRadioGroup(@Nullable String string) {
        this.m_sRadioGroup = string;
        return this;
    }

    @Nonnull
    public final EHCCommandType getType() {
        return this.m_eType;
    }

    @Nonnull
    public final HCCommand setType(@Nonnull EHCCommandType eHCCommandType) {
        this.m_eType = (EHCCommandType)ValueEnforcer.notNull((Object)eHCCommandType, (String)"Type");
        return this;
    }

    @Override
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (this.m_bChecked) {
            iMicroElement.setAttribute(CHTMLAttributes.CHECKED, CHTMLAttributeValues.CHECKED);
        }
        if (this.m_bDefault) {
            iMicroElement.setAttribute(CHTMLAttributes.DEFAULT, CHTMLAttributeValues.DEFAULT);
        }
        if (this.m_bDisabled) {
            iMicroElement.setAttribute(CHTMLAttributes.DISABLED, CHTMLAttributeValues.DISABLED);
        }
        if (this.m_aIcon != null) {
            iMicroElement.setAttribute(CHTMLAttributes.ICON, this.m_aIcon.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset()));
        }
        if (StringHelper.hasText((String)this.m_sLabel)) {
            iMicroElement.setAttribute(CHTMLAttributes.LABEL, this.m_sLabel);
        }
        if (StringHelper.hasText((String)this.m_sRadioGroup) && EHCCommandType.RADIO.equals(this.m_eType)) {
            iMicroElement.setAttribute(CHTMLAttributes.RADIOGROUP, this.m_sRadioGroup);
        }
        iMicroElement.setAttribute(CHTMLAttributes.TYPE, (IHasAttributeValue)this.m_eType);
    }

    @Override
    @Nonnull
    public String getPlainText() {
        return StringHelper.getNotNull((String)this.m_sLabel);
    }
}

